/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.common.utils.IOUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    public static final String ANYHOST = "0.0.0.0";
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    public static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");

    public static boolean isInvalidPort(int port) {
        return port > 65535 || port < 0;
    }

    public static boolean isRandomPort(int port) {
        return port == -1;
    }

    public static int getAvailablePort(String host, int port) {
        return NetUtils.getAvailablePort(host, port, 65535);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailablePort(String host, int port, int maxPort) {
        if (NetUtils.isAnyHost(host) || NetUtils.isLocalHost(host) || NetUtils.isHostInNetworkCard(host)) {
            if (port < 0) {
                port = 0;
            }
            for (int i = port; i <= maxPort; ++i) {
                ServerSocket ss = null;
                try {
                    ss = new ServerSocket();
                    ss.bind(new InetSocketAddress(host, i));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("ip:{} port:{} is available", host, i);
                    }
                    int n = i;
                    return n;
                }
                catch (IOException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Can't bind to address [{}:{}], Maybe 1) The port has been bound. 2) The network card of this host is not exists or disable. 3) The host is wrong.", host, i);
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Begin try next port(auto +1):{}", i + 1);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly(ss);
                }
            }
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990023", host));
        }
        throw new SofaRpcRuntimeException(LogCodes.getLog("019990024", host));
    }

    public static boolean isLocalHost(String host) {
        return StringUtils.isNotBlank(host) && (LOCAL_IP_PATTERN.matcher(host).matches() || "localhost".equalsIgnoreCase(host));
    }

    public static boolean isAnyHost(String host) {
        return ANYHOST.equals(host);
    }

    public static boolean isIPv4Host(String host) {
        return StringUtils.isNotBlank(host) && IPV4_PATTERN.matcher(host).matches();
    }

    static boolean isInvalidLocalHost(String host) {
        return StringUtils.isBlank(host) || NetUtils.isAnyHost(host) || NetUtils.isLocalHost(host);
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !NetUtils.isAnyHost(name) && !NetUtils.isLocalHost(name) && NetUtils.isIPv4Host(name);
    }

    public static boolean isHostInNetworkCard(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getLocalIpv4() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? null : address.getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        block14: {
            block13: {
                localAddress = null;
                try {
                    localAddress = InetAddress.getLocalHost();
                    if (NetUtils.isValidAddress(localAddress)) {
                        return localAddress;
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isWarnEnabled()) break block13;
                    LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
                }
            }
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces != null) {
                    while (interfaces.hasMoreElements()) {
                        try {
                            NetworkInterface network = interfaces.nextElement();
                            Enumeration<InetAddress> addresses = network.getInetAddresses();
                            while (addresses.hasMoreElements()) {
                                try {
                                    InetAddress address = addresses.nextElement();
                                    if (!NetUtils.isValidAddress(address)) continue;
                                    return address;
                                }
                                catch (Throwable e) {
                                    if (!LOGGER.isWarnEnabled()) continue;
                                    LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isWarnEnabled()) continue;
                            LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isWarnEnabled()) break block14;
                LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
            }
        }
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(LogCodes.getLog("019990020"));
        }
        return localAddress;
    }

    public static String toAddressString(InetSocketAddress address) {
        if (address == null) {
            return "";
        }
        return NetUtils.toIpString(address) + ":" + address.getPort();
    }

    public static String toIpString(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        InetAddress inetAddress = address.getAddress();
        return inetAddress == null ? address.getHostName() : inetAddress.getHostAddress();
    }

    public static String getLocalHostByRegistry(String registryIp) {
        String host = null;
        if (registryIp != null && registryIp.length() > 0) {
            List<InetSocketAddress> addrs = NetUtils.getIpListByRegistry(registryIp);
            for (int i = 0; i < addrs.size(); ++i) {
                InetAddress address = NetUtils.getLocalHostBySocket(addrs.get(i));
                if (address == null || (host = address.getHostAddress()) == null || NetUtils.isInvalidLocalHost(host)) continue;
                return host;
            }
        }
        if (NetUtils.isInvalidLocalHost(host)) {
            host = NetUtils.getLocalIpv4();
        }
        return host;
    }

    private static InetAddress getLocalHostBySocket(InetSocketAddress remoteAddress) {
        InetAddress host = null;
        try {
            Socket socket = new Socket();
            try {
                socket.connect(remoteAddress, 1000);
                host = socket.getLocalAddress();
            }
            finally {
                IOUtils.closeQuietly(socket);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can not connect to host {}, cause by :{}", remoteAddress.toString(), e.getMessage());
        }
        return host;
    }

    public static List<InetSocketAddress> getIpListByRegistry(String registryIp) {
        String[] srcIps;
        ArrayList<String[]> ips = new ArrayList<String[]>();
        String defaultPort = null;
        for (String add : srcIps = registryIp.split(",")) {
            String[] s1;
            int a = add.indexOf("://");
            if (a > -1) {
                add = add.substring(a + 3);
            }
            if ((s1 = add.split(":")).length > 1) {
                if (defaultPort == null && s1[1] != null && s1[1].length() > 0) {
                    defaultPort = s1[1];
                }
                ips.add(new String[]{s1[0], s1[1]});
                continue;
            }
            ips.add(new String[]{s1[0], defaultPort});
        }
        ArrayList<InetSocketAddress> ads = new ArrayList<InetSocketAddress>();
        for (int j = 0; j < ips.size(); ++j) {
            String[] ip = (String[])ips.get(j);
            try {
                InetSocketAddress address = new InetSocketAddress(ip[0], Integer.parseInt(ip[1] == null ? defaultPort : ip[1]));
                ads.add(address);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ads;
    }

    public static boolean isMatchIPByPattern(String whiteList, String localIP) {
        if (StringUtils.isNotBlank(whiteList)) {
            if ("*".equals(whiteList)) {
                return true;
            }
            for (String ips : whiteList.replace(',', ';').split(";", -1)) {
                try {
                    String regex;
                    Pattern pattern;
                    if (ips.contains("*") ? (pattern = Pattern.compile(regex = ips.trim().replace(".", "\\.").replace("*", ".*"))).matcher(localIP).find() : (!NetUtils.isIPv4Host(ips) ? (pattern = Pattern.compile(regex = ips.trim().replace(".", "\\."))).matcher(localIP).find() : ips.equals(localIP))) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("syntax of pattern {} is invalid", ips);
                }
            }
        }
        return false;
    }

    public static String connectToString(InetSocketAddress local, InetSocketAddress remote) {
        return NetUtils.toAddressString(local) + " <-> " + NetUtils.toAddressString(remote);
    }

    public static String channelToString(SocketAddress local1, SocketAddress remote1) {
        try {
            InetSocketAddress local = (InetSocketAddress)local1;
            InetSocketAddress remote = (InetSocketAddress)remote1;
            return NetUtils.toAddressString(local) + " -> " + NetUtils.toAddressString(remote);
        }
        catch (Exception e) {
            return local1 + "->" + remote1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canTelnet(String ip, int port, int timeout) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(ip, port), timeout);
            boolean bl = socket.isConnected() && !socket.isClosed();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(socket);
        }
    }

    public static void joinMulticastGroup(MulticastSocket multicastSocket, InetAddress multicastAddress) throws IOException {
        NetUtils.setInterface(multicastSocket, multicastAddress instanceof Inet6Address);
        multicastSocket.setLoopbackMode(false);
        multicastSocket.joinGroup(multicastAddress);
    }

    public static void setInterface(MulticastSocket multicastSocket, boolean preferIpv6) throws IOException {
        boolean interfaceSet = false;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface i = interfaces.nextElement();
            Enumeration<InetAddress> addresses = i.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (preferIpv6 && address instanceof Inet6Address) {
                    try {
                        if (!address.isReachable(100)) continue;
                        multicastSocket.setInterface(address);
                        interfaceSet = true;
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (preferIpv6 || !(address instanceof Inet4Address)) continue;
                try {
                    if (!address.isReachable(100)) continue;
                    multicastSocket.setInterface(address);
                    interfaceSet = true;
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (!interfaceSet) continue;
            break;
        }
    }
}

