/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.plugin.mock.api.MockRequest;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.util.MockUtil;
import org.apache.shenyu.spi.Join;

@Join
public class RandomDoubleGenerator
implements Generator<String> {
    @Override
    public String getName() {
        return "double";
    }

    @Override
    public String doGenerate(List<String> params, String rule, MockRequest mockRequest) {
        String[] range = params.get(0).split("-");
        double min = Double.parseDouble(range[0]);
        double max = Double.parseDouble(range[1]);
        String format = null;
        if (params.size() == 2) {
            format = Objects.equals(params.get(1), "") ? null : params.get(1);
        }
        return MockUtil.randomDouble(min, max, format).toString();
    }

    @Override
    public int getParamSize() {
        return 1;
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^double\\|\\d+(?:\\.\\d+)?-\\d+(?:\\.\\d+)?.*");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"\"", "\""};
    }
}

