/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.ProviderProtectedStrategy;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.StatisticCallback;
import com.weibo.api.motan.util.StatsUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@SpiMeta(name="motan")
public class DefaultProtectedStrategy
implements ProviderProtectedStrategy,
StatisticCallback {
    protected ConcurrentMap<String, AtomicInteger> requestCounters = new ConcurrentHashMap<String, AtomicInteger>();
    protected ConcurrentMap<String, AtomicInteger> rejectCounters = new ConcurrentHashMap<String, AtomicInteger>();
    protected AtomicInteger totalCounter = new AtomicInteger(0);
    protected AtomicInteger rejectCounter = new AtomicInteger(0);
    protected AtomicInteger methodCounter = new AtomicInteger(1);

    public DefaultProtectedStrategy() {
        StatsUtil.registryStatisticCallback(this);
    }

    @Override
    public void setMethodCounter(AtomicInteger methodCounter) {
        this.methodCounter = methodCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response call(Request request, Provider<?> provider) {
        int maxThread = provider.getUrl().getIntParameter(URLParamType.maxWorkerThread.getName(), URLParamType.maxWorkerThread.getIntValue());
        String requestKey = MotanFrameworkUtil.getFullMethodString(request);
        try {
            int requestCounter = this.incrCounter(requestKey, this.requestCounters);
            int totalCounter = this.incrTotalCounter();
            if (this.isAllowRequest(requestCounter, totalCounter, maxThread)) {
                Response response = provider.call(request);
                return response;
            }
            Response response = this.reject(request.getInterfaceName() + "." + request.getMethodName(), requestCounter, totalCounter, maxThread, request);
            return response;
        }
        finally {
            this.decrTotalCounter();
            this.decrCounter(requestKey, this.requestCounters);
        }
    }

    private Response reject(String method, int requestCounter, int totalCounter, int maxThread, Request request) {
        String message = "ThreadProtectedRequestRouter reject request: request_method=" + method + " request_counter=" + requestCounter + " total_counter=" + totalCounter + " max_thread=" + maxThread;
        MotanServiceException exception = new MotanServiceException(message, MotanErrorMsgConstant.SERVICE_REJECT, false);
        DefaultResponse response = MotanFrameworkUtil.buildErrorResponse(request, exception);
        LoggerUtil.error(exception.getMessage());
        this.incrCounter(method, this.rejectCounters);
        this.rejectCounter.incrementAndGet();
        return response;
    }

    private int incrCounter(String requestKey, ConcurrentMap<String, AtomicInteger> counters) {
        AtomicInteger counter = (AtomicInteger)counters.get(requestKey);
        if (counter == null) {
            counter = new AtomicInteger(0);
            counters.putIfAbsent(requestKey, counter);
            counter = (AtomicInteger)counters.get(requestKey);
        }
        return counter.incrementAndGet();
    }

    private int decrCounter(String requestKey, ConcurrentMap<String, AtomicInteger> counters) {
        AtomicInteger counter = (AtomicInteger)counters.get(requestKey);
        if (counter == null) {
            return 0;
        }
        return counter.decrementAndGet();
    }

    private int incrTotalCounter() {
        return this.totalCounter.incrementAndGet();
    }

    private int decrTotalCounter() {
        return this.totalCounter.decrementAndGet();
    }

    public boolean isAllowRequest(int requestCounter, int totalCounter, int maxThread) {
        if (this.methodCounter.get() == 1 || requestCounter == 1) {
            return true;
        }
        if (requestCounter > maxThread / 2 && totalCounter > maxThread * 3 / 4) {
            return false;
        }
        return this.methodCounter.get() < 4 || totalCounter <= maxThread * 3 / 4 || requestCounter <= maxThread / 4;
    }

    @Override
    public String statisticCallback() {
        int count = this.rejectCounter.getAndSet(0);
        if (count > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("type:").append("motan").append(" ").append("name:").append("reject_request").append(" ").append("total_count:").append(this.totalCounter.get()).append(" ").append("reject_count:").append(count).append(" ");
            for (Map.Entry entry : this.rejectCounters.entrySet()) {
                String key = (String)entry.getKey();
                int cnt = ((AtomicInteger)entry.getValue()).getAndSet(0);
                builder.append(key).append("_reject:").append(cnt).append(" ");
            }
            return builder.toString();
        }
        return null;
    }
}

