/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.DefaultRpcReferer;
import com.weibo.api.motan.protocol.support.ProtocolFilterDecorator;
import com.weibo.api.motan.protocol.v2motan.MotanV2Protocol;
import com.weibo.api.motan.rpc.DefaultResponseFuture;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.transport.MeshClient;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DefaultMeshClient
implements MeshClient {
    static final DefaultMeshClient DEFAULT_MESH_CLIENT;
    Referer<MeshClient> innerReferer;
    private URL meshUrl;

    public static DefaultMeshClient getDefault() {
        if (!DEFAULT_MESH_CLIENT.isAvailable()) {
            DEFAULT_MESH_CLIENT.init();
        }
        return DEFAULT_MESH_CLIENT;
    }

    public static Map<String, String> getDefaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(URLParamType.meshMPort.getName(), String.valueOf(8002));
        params.put(URLParamType.application.getName(), "meshClient");
        params.put(URLParamType.group.getName(), "meshClient");
        params.put(URLParamType.module.getName(), "meshClient");
        params.put(URLParamType.codec.getName(), "motan2");
        params.put(URLParamType.protocol.getName(), "motan2");
        params.put(URLParamType.fusingThreshold.getName(), String.valueOf(Integer.MAX_VALUE));
        return params;
    }

    public DefaultMeshClient(URL url) {
        this.meshUrl = url;
    }

    public Class getInterface() {
        return MeshClient.class;
    }

    @Override
    public Response call(Request request) {
        return this.innerReferer.call(request);
    }

    @Override
    public <T> T call(Request request, Class<T> returnType) throws Exception {
        Response response = this.innerReferer.call(request);
        Object result = null;
        if (response != null) {
            if (response.getValue() instanceof DeserializableObject) {
                try {
                    result = ((DeserializableObject)response.getValue()).deserialize(returnType);
                }
                catch (IOException e) {
                    LoggerUtil.error("deserialize response value fail! deserialize type:" + returnType, e);
                    throw new MotanFrameworkException("deserialize return value fail! deserialize type:" + returnType, e);
                }
            } else {
                result = response.getValue();
            }
        }
        return (T)result;
    }

    @Override
    public ResponseFuture asyncCall(Request request, Class<?> returnType) throws Exception {
        ResponseFuture result;
        Response response = this.innerReferer.call(request);
        if (response instanceof ResponseFuture) {
            result = (ResponseFuture)response;
            result.setReturnType(returnType);
        } else {
            result = new DefaultResponseFuture(request, 0, this.innerReferer.getUrl());
            if (response.getException() != null) {
                result.onFailure(response);
            } else {
                result.onSuccess(response);
            }
            result.setReturnType(returnType);
        }
        return result;
    }

    @Override
    public synchronized void init() {
        ProtocolFilterDecorator decorator = new ProtocolFilterDecorator(new MotanV2Protocol());
        this.innerReferer = decorator.decorateRefererFilter(new InnerMeshReferer<MeshClient>(MeshClient.class, this.meshUrl), this.meshUrl);
        this.innerReferer.init();
    }

    @Override
    public boolean isAvailable() {
        return this.innerReferer != null && this.innerReferer.isAvailable();
    }

    @Override
    public String desc() {
        return "DefaultMeshClient - url:" + this.innerReferer.getUrl().toFullStr();
    }

    @Override
    public synchronized void destroy() {
        if (this.innerReferer != null) {
            this.innerReferer.destroy();
        }
    }

    @Override
    public URL getUrl() {
        return this.meshUrl;
    }

    static {
        URL defaultUrl = new URL("motan2", "localhost", 9981, MeshClient.class.getName(), DefaultMeshClient.getDefaultParams());
        DEFAULT_MESH_CLIENT = new DefaultMeshClient(defaultUrl);
    }

    static class InnerMeshReferer<MeshClient>
    extends DefaultRpcReferer<MeshClient> {
        public InnerMeshReferer(Class<MeshClient> clz, URL url) {
            super(clz, url, url);
        }

        @Override
        public Response call(Request request) {
            if (!this.isAvailable()) {
                throw new MotanFrameworkException("DefaultMeshClient call Error: mesh client is not available, url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString(request));
            }
            return this.doCall(request);
        }

        @Override
        protected Response doCall(Request request) {
            try {
                return this.client.request(request);
            }
            catch (TransportException exception) {
                throw new MotanServiceException("DefaultMeshClient call Error: url=" + this.url.getUri(), exception);
            }
        }
    }
}

