/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.extractor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.plugin.sign.api.SignParameters;
import org.apache.shenyu.plugin.sign.extractor.SignParameterExtractor;
import org.apache.shenyu.plugin.sign.extractor.VersionOneExtractor;
import org.apache.shenyu.plugin.sign.extractor.VersionTwoExtractor;
import org.springframework.http.HttpRequest;

public class DefaultExtractor
implements SignParameterExtractor {
    public static final String VERSION_1 = "1.0.0";
    public static final String VERSION_2 = "2.0.0";
    private static final Map<String, SignParameterExtractor> VERSION_EXTRACTOR = ImmutableMap.of((Object)"1.0.0", (Object)new VersionOneExtractor(), (Object)"2.0.0", (Object)new VersionTwoExtractor());

    @Override
    public SignParameters extract(HttpRequest httpRequest) {
        String version = httpRequest.getHeaders().getFirst("version");
        if (Objects.isNull(version)) {
            return SignParameters.VERSION_ERROR_PARAMETERS;
        }
        SignParameterExtractor extractor = VERSION_EXTRACTOR.get(version);
        if (Objects.isNull(extractor)) {
            return SignParameters.VERSION_ERROR_PARAMETERS;
        }
        return extractor.extract(httpRequest);
    }
}

