/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_ruleset;

import co.elastic.clients.elasticsearch._types.query_dsl.PinnedDoc;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRuleActions
implements JsonpSerializable {
    private final List<String> ids;
    private final List<PinnedDoc> docs;
    public static final JsonpDeserializer<QueryRuleActions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRuleActions::setupQueryRuleActionsDeserializer);

    private QueryRuleActions(Builder builder) {
        this.ids = ApiTypeHelper.unmodifiable(builder.ids);
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
    }

    public static QueryRuleActions of(Function<Builder, ObjectBuilder<QueryRuleActions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final List<PinnedDoc> docs() {
        return this.docs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (PinnedDoc pinnedDoc : this.docs) {
                pinnedDoc.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryRuleActionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(PinnedDoc._DESERIALIZER), "docs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRuleActions> {
        @Nullable
        private List<String> ids;
        @Nullable
        private List<PinnedDoc> docs;

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder docs(List<PinnedDoc> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(PinnedDoc value, PinnedDoc ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder docs(Function<PinnedDoc.Builder, ObjectBuilder<PinnedDoc>> fn) {
            return this.docs(fn.apply(new PinnedDoc.Builder()).build(), new PinnedDoc[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRuleActions build() {
            this._checkSingleUse();
            return new QueryRuleActions(this);
        }
    }
}

