/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.JsonProcessorConflictStrategy;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JsonProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final Boolean addToRoot;
    @Nullable
    private final JsonProcessorConflictStrategy addToRootConflictStrategy;
    @Nullable
    private final Boolean allowDuplicateKeys;
    private final String field;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<JsonProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JsonProcessor::setupJsonProcessorDeserializer);

    private JsonProcessor(Builder builder) {
        super(builder);
        this.addToRoot = builder.addToRoot;
        this.addToRootConflictStrategy = builder.addToRootConflictStrategy;
        this.allowDuplicateKeys = builder.allowDuplicateKeys;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.targetField = builder.targetField;
    }

    public static JsonProcessor of(Function<Builder, ObjectBuilder<JsonProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Json;
    }

    @Nullable
    public final Boolean addToRoot() {
        return this.addToRoot;
    }

    @Nullable
    public final JsonProcessorConflictStrategy addToRootConflictStrategy() {
        return this.addToRootConflictStrategy;
    }

    @Nullable
    public final Boolean allowDuplicateKeys() {
        return this.allowDuplicateKeys;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.addToRoot != null) {
            generator.writeKey("add_to_root");
            generator.write(this.addToRoot.booleanValue());
        }
        if (this.addToRootConflictStrategy != null) {
            generator.writeKey("add_to_root_conflict_strategy");
            this.addToRootConflictStrategy.serialize(generator, mapper);
        }
        if (this.allowDuplicateKeys != null) {
            generator.writeKey("allow_duplicate_keys");
            generator.write(this.allowDuplicateKeys.booleanValue());
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    protected static void setupJsonProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::addToRoot, JsonpDeserializer.booleanDeserializer(), "add_to_root");
        op.add(Builder::addToRootConflictStrategy, JsonProcessorConflictStrategy._DESERIALIZER, "add_to_root_conflict_strategy");
        op.add(Builder::allowDuplicateKeys, JsonpDeserializer.booleanDeserializer(), "allow_duplicate_keys");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JsonProcessor> {
        @Nullable
        private Boolean addToRoot;
        @Nullable
        private JsonProcessorConflictStrategy addToRootConflictStrategy;
        @Nullable
        private Boolean allowDuplicateKeys;
        private String field;
        @Nullable
        private String targetField;

        public final Builder addToRoot(@Nullable Boolean value) {
            this.addToRoot = value;
            return this;
        }

        public final Builder addToRootConflictStrategy(@Nullable JsonProcessorConflictStrategy value) {
            this.addToRootConflictStrategy = value;
            return this;
        }

        public final Builder allowDuplicateKeys(@Nullable Boolean value) {
            this.allowDuplicateKeys = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JsonProcessor build() {
            this._checkSingleUse();
            return new JsonProcessor(this);
        }
    }
}

