/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch.core.health_report.IndicatorNode;
import co.elastic.clients.elasticsearch.core.health_report.MasterIsStableIndicatorClusterFormationNode;
import co.elastic.clients.elasticsearch.core.health_report.MasterIsStableIndicatorExceptionFetchingHistory;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MasterIsStableIndicatorDetails
implements JsonpSerializable {
    private final IndicatorNode currentMaster;
    private final List<IndicatorNode> recentMasters;
    @Nullable
    private final MasterIsStableIndicatorExceptionFetchingHistory exceptionFetchingHistory;
    private final List<MasterIsStableIndicatorClusterFormationNode> clusterFormation;
    public static final JsonpDeserializer<MasterIsStableIndicatorDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MasterIsStableIndicatorDetails::setupMasterIsStableIndicatorDetailsDeserializer);

    private MasterIsStableIndicatorDetails(Builder builder) {
        this.currentMaster = ApiTypeHelper.requireNonNull(builder.currentMaster, this, "currentMaster");
        this.recentMasters = ApiTypeHelper.unmodifiableRequired(builder.recentMasters, (Object)this, "recentMasters");
        this.exceptionFetchingHistory = builder.exceptionFetchingHistory;
        this.clusterFormation = ApiTypeHelper.unmodifiable(builder.clusterFormation);
    }

    public static MasterIsStableIndicatorDetails of(Function<Builder, ObjectBuilder<MasterIsStableIndicatorDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final IndicatorNode currentMaster() {
        return this.currentMaster;
    }

    public final List<IndicatorNode> recentMasters() {
        return this.recentMasters;
    }

    @Nullable
    public final MasterIsStableIndicatorExceptionFetchingHistory exceptionFetchingHistory() {
        return this.exceptionFetchingHistory;
    }

    public final List<MasterIsStableIndicatorClusterFormationNode> clusterFormation() {
        return this.clusterFormation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_master");
        this.currentMaster.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.recentMasters)) {
            generator.writeKey("recent_masters");
            generator.writeStartArray();
            for (IndicatorNode indicatorNode : this.recentMasters) {
                indicatorNode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.exceptionFetchingHistory != null) {
            generator.writeKey("exception_fetching_history");
            this.exceptionFetchingHistory.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.clusterFormation)) {
            generator.writeKey("cluster_formation");
            generator.writeStartArray();
            for (MasterIsStableIndicatorClusterFormationNode masterIsStableIndicatorClusterFormationNode : this.clusterFormation) {
                masterIsStableIndicatorClusterFormationNode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMasterIsStableIndicatorDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentMaster, IndicatorNode._DESERIALIZER, "current_master");
        op.add(Builder::recentMasters, JsonpDeserializer.arrayDeserializer(IndicatorNode._DESERIALIZER), "recent_masters");
        op.add(Builder::exceptionFetchingHistory, MasterIsStableIndicatorExceptionFetchingHistory._DESERIALIZER, "exception_fetching_history");
        op.add(Builder::clusterFormation, JsonpDeserializer.arrayDeserializer(MasterIsStableIndicatorClusterFormationNode._DESERIALIZER), "cluster_formation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MasterIsStableIndicatorDetails> {
        private IndicatorNode currentMaster;
        private List<IndicatorNode> recentMasters;
        @Nullable
        private MasterIsStableIndicatorExceptionFetchingHistory exceptionFetchingHistory;
        @Nullable
        private List<MasterIsStableIndicatorClusterFormationNode> clusterFormation;

        public final Builder currentMaster(IndicatorNode value) {
            this.currentMaster = value;
            return this;
        }

        public final Builder currentMaster(Function<IndicatorNode.Builder, ObjectBuilder<IndicatorNode>> fn) {
            return this.currentMaster(fn.apply(new IndicatorNode.Builder()).build());
        }

        public final Builder recentMasters(List<IndicatorNode> list) {
            this.recentMasters = Builder._listAddAll(this.recentMasters, list);
            return this;
        }

        public final Builder recentMasters(IndicatorNode value, IndicatorNode ... values) {
            this.recentMasters = Builder._listAdd(this.recentMasters, value, values);
            return this;
        }

        public final Builder recentMasters(Function<IndicatorNode.Builder, ObjectBuilder<IndicatorNode>> fn) {
            return this.recentMasters(fn.apply(new IndicatorNode.Builder()).build(), new IndicatorNode[0]);
        }

        public final Builder exceptionFetchingHistory(@Nullable MasterIsStableIndicatorExceptionFetchingHistory value) {
            this.exceptionFetchingHistory = value;
            return this;
        }

        public final Builder exceptionFetchingHistory(Function<MasterIsStableIndicatorExceptionFetchingHistory.Builder, ObjectBuilder<MasterIsStableIndicatorExceptionFetchingHistory>> fn) {
            return this.exceptionFetchingHistory(fn.apply(new MasterIsStableIndicatorExceptionFetchingHistory.Builder()).build());
        }

        public final Builder clusterFormation(List<MasterIsStableIndicatorClusterFormationNode> list) {
            this.clusterFormation = Builder._listAddAll(this.clusterFormation, list);
            return this;
        }

        public final Builder clusterFormation(MasterIsStableIndicatorClusterFormationNode value, MasterIsStableIndicatorClusterFormationNode ... values) {
            this.clusterFormation = Builder._listAdd(this.clusterFormation, value, values);
            return this;
        }

        public final Builder clusterFormation(Function<MasterIsStableIndicatorClusterFormationNode.Builder, ObjectBuilder<MasterIsStableIndicatorClusterFormationNode>> fn) {
            return this.clusterFormation(fn.apply(new MasterIsStableIndicatorClusterFormationNode.Builder()).build(), new MasterIsStableIndicatorClusterFormationNode[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MasterIsStableIndicatorDetails build() {
            this._checkSingleUse();
            return new MasterIsStableIndicatorDetails(this);
        }
    }
}

