/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexingPressureMemorySummary
implements JsonpSerializable {
    private final long allInBytes;
    private final long combinedCoordinatingAndPrimaryInBytes;
    private final long coordinatingInBytes;
    @Nullable
    private final Long coordinatingRejections;
    private final long primaryInBytes;
    @Nullable
    private final Long primaryRejections;
    private final long replicaInBytes;
    @Nullable
    private final Long replicaRejections;
    public static final JsonpDeserializer<IndexingPressureMemorySummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexingPressureMemorySummary::setupIndexingPressureMemorySummaryDeserializer);

    private IndexingPressureMemorySummary(Builder builder) {
        this.allInBytes = ApiTypeHelper.requireNonNull(builder.allInBytes, this, "allInBytes");
        this.combinedCoordinatingAndPrimaryInBytes = ApiTypeHelper.requireNonNull(builder.combinedCoordinatingAndPrimaryInBytes, this, "combinedCoordinatingAndPrimaryInBytes");
        this.coordinatingInBytes = ApiTypeHelper.requireNonNull(builder.coordinatingInBytes, this, "coordinatingInBytes");
        this.coordinatingRejections = builder.coordinatingRejections;
        this.primaryInBytes = ApiTypeHelper.requireNonNull(builder.primaryInBytes, this, "primaryInBytes");
        this.primaryRejections = builder.primaryRejections;
        this.replicaInBytes = ApiTypeHelper.requireNonNull(builder.replicaInBytes, this, "replicaInBytes");
        this.replicaRejections = builder.replicaRejections;
    }

    public static IndexingPressureMemorySummary of(Function<Builder, ObjectBuilder<IndexingPressureMemorySummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long allInBytes() {
        return this.allInBytes;
    }

    public final long combinedCoordinatingAndPrimaryInBytes() {
        return this.combinedCoordinatingAndPrimaryInBytes;
    }

    public final long coordinatingInBytes() {
        return this.coordinatingInBytes;
    }

    @Nullable
    public final Long coordinatingRejections() {
        return this.coordinatingRejections;
    }

    public final long primaryInBytes() {
        return this.primaryInBytes;
    }

    @Nullable
    public final Long primaryRejections() {
        return this.primaryRejections;
    }

    public final long replicaInBytes() {
        return this.replicaInBytes;
    }

    @Nullable
    public final Long replicaRejections() {
        return this.replicaRejections;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("all_in_bytes");
        generator.write(this.allInBytes);
        generator.writeKey("combined_coordinating_and_primary_in_bytes");
        generator.write(this.combinedCoordinatingAndPrimaryInBytes);
        generator.writeKey("coordinating_in_bytes");
        generator.write(this.coordinatingInBytes);
        if (this.coordinatingRejections != null) {
            generator.writeKey("coordinating_rejections");
            generator.write(this.coordinatingRejections.longValue());
        }
        generator.writeKey("primary_in_bytes");
        generator.write(this.primaryInBytes);
        if (this.primaryRejections != null) {
            generator.writeKey("primary_rejections");
            generator.write(this.primaryRejections.longValue());
        }
        generator.writeKey("replica_in_bytes");
        generator.write(this.replicaInBytes);
        if (this.replicaRejections != null) {
            generator.writeKey("replica_rejections");
            generator.write(this.replicaRejections.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexingPressureMemorySummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allInBytes, JsonpDeserializer.longDeserializer(), "all_in_bytes");
        op.add(Builder::combinedCoordinatingAndPrimaryInBytes, JsonpDeserializer.longDeserializer(), "combined_coordinating_and_primary_in_bytes");
        op.add(Builder::coordinatingInBytes, JsonpDeserializer.longDeserializer(), "coordinating_in_bytes");
        op.add(Builder::coordinatingRejections, JsonpDeserializer.longDeserializer(), "coordinating_rejections");
        op.add(Builder::primaryInBytes, JsonpDeserializer.longDeserializer(), "primary_in_bytes");
        op.add(Builder::primaryRejections, JsonpDeserializer.longDeserializer(), "primary_rejections");
        op.add(Builder::replicaInBytes, JsonpDeserializer.longDeserializer(), "replica_in_bytes");
        op.add(Builder::replicaRejections, JsonpDeserializer.longDeserializer(), "replica_rejections");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexingPressureMemorySummary> {
        private Long allInBytes;
        private Long combinedCoordinatingAndPrimaryInBytes;
        private Long coordinatingInBytes;
        @Nullable
        private Long coordinatingRejections;
        private Long primaryInBytes;
        @Nullable
        private Long primaryRejections;
        private Long replicaInBytes;
        @Nullable
        private Long replicaRejections;

        public final Builder allInBytes(long value) {
            this.allInBytes = value;
            return this;
        }

        public final Builder combinedCoordinatingAndPrimaryInBytes(long value) {
            this.combinedCoordinatingAndPrimaryInBytes = value;
            return this;
        }

        public final Builder coordinatingInBytes(long value) {
            this.coordinatingInBytes = value;
            return this;
        }

        public final Builder coordinatingRejections(@Nullable Long value) {
            this.coordinatingRejections = value;
            return this;
        }

        public final Builder primaryInBytes(long value) {
            this.primaryInBytes = value;
            return this;
        }

        public final Builder primaryRejections(@Nullable Long value) {
            this.primaryRejections = value;
            return this;
        }

        public final Builder replicaInBytes(long value) {
            this.replicaInBytes = value;
            return this;
        }

        public final Builder replicaRejections(@Nullable Long value) {
            this.replicaRejections = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexingPressureMemorySummary build() {
            this._checkSingleUse();
            return new IndexingPressureMemorySummary(this);
        }
    }
}

