/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer.collection;

import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.serializer.collection.CollectionSerializer;
import io.fury.serializer.collection.MapSerializer;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.slf4j.Logger;

public class UnmodifiableSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(UnmodifiableSerializers.class);

    static Serializer createSerializer(Fury fury, Class<?> cls) {
        for (Tuple2<Class<?>, Function> factory : UnmodifiableSerializers.unmodifiableFactories()) {
            if (factory.f0 != cls) continue;
            return UnmodifiableSerializers.createSerializer(fury, factory);
        }
        throw new IllegalArgumentException("Unsupported type " + cls);
    }

    private static Serializer<?> createSerializer(Fury fury, Tuple2<Class<?>, Function> factory) {
        if (Collection.class.isAssignableFrom((Class)factory.f0)) {
            return new UnmodifiableCollectionSerializer(fury, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_COLLECTION_FIELD_OFFSET);
        }
        return new UnmodifiableMapSerializer(fury, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_MAP_FIELD_OFFSET);
    }

    static Tuple2<Class<?>, Function>[] unmodifiableFactories() {
        Tuple2<Class<?>, Function<Object, Object>> collectionFactory = Tuple2.of(Collections.unmodifiableCollection(Collections.singletonList("")).getClass(), o -> Collections.unmodifiableCollection((Collection)o));
        Tuple2<Class<?>, Function<Object, Object>> randomAccessListFactory = Tuple2.of(Collections.unmodifiableList(new ArrayList()).getClass(), o -> Collections.unmodifiableList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> listFactory = Tuple2.of(Collections.unmodifiableList(new LinkedList()).getClass(), o -> Collections.unmodifiableList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> setFactory = Tuple2.of(Collections.unmodifiableSet(new HashSet()).getClass(), o -> Collections.unmodifiableSet((Set)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedsetFactory = Tuple2.of(Collections.unmodifiableSortedSet(new TreeSet()).getClass(), o -> Collections.unmodifiableSortedSet((SortedSet)o));
        Tuple2<Class<?>, Function<Object, Object>> mapFactory = Tuple2.of(Collections.unmodifiableMap(new HashMap()).getClass(), o -> Collections.unmodifiableMap((Map)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedmapFactory = Tuple2.of(Collections.unmodifiableSortedMap(new TreeMap()).getClass(), o -> Collections.unmodifiableSortedMap((SortedMap)o));
        return new Tuple2[]{collectionFactory, randomAccessListFactory, listFactory, setFactory, sortedsetFactory, mapFactory, sortedmapFactory};
    }

    public static void registerSerializers(Fury fury) {
        try {
            for (Tuple2<Class<?>, Function> factory : UnmodifiableSerializers.unmodifiableFactories()) {
                fury.registerSerializer((Class)factory.f0, UnmodifiableSerializers.createSerializer(fury, factory));
            }
        }
        catch (Throwable e) {
            Utils.ignore(e);
        }
    }

    public static final class UnmodifiableCollectionSerializer
    extends CollectionSerializer<Collection> {
        private final Function factory;
        private final long offset;

        public UnmodifiableCollectionSerializer(Fury fury, Class cls, Function factory, long offset) {
            super(fury, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        @Override
        public void write(MemoryBuffer buffer, Collection value) {
            Preconditions.checkArgument(value.getClass() == this.type);
            Object fieldValue = Platform.getObject(value, this.offset);
            this.fury.writeRef(buffer, fieldValue);
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Collection)this.factory.apply(sourceCollection);
        }
    }

    private static class Offset {
        private static final long SOURCE_COLLECTION_FIELD_OFFSET;
        private static final long SOURCE_MAP_FIELD_OFFSET;

        private Offset() {
        }

        static {
            String clsName = "java.util.Collections$UnmodifiableCollection";
            try {
                SOURCE_COLLECTION_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("c"));
            }
            catch (Exception e) {
                LOG.info("Could not access source collection field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
            clsName = "java.util.Collections$UnmodifiableMap";
            try {
                SOURCE_MAP_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("m"));
            }
            catch (Exception e) {
                LOG.info("Could not access source map field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
        }
    }

    public static final class UnmodifiableMapSerializer
    extends MapSerializer<Map> {
        private final Function factory;
        private final long offset;

        public UnmodifiableMapSerializer(Fury fury, Class cls, Function factory, long offset) {
            super(fury, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        @Override
        public void write(MemoryBuffer buffer, Map value) {
            Preconditions.checkArgument(value.getClass() == this.type);
            Object fieldValue = Platform.getObject(value, this.offset);
            this.fury.writeRef(buffer, fieldValue);
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Map)this.factory.apply(sourceCollection);
        }
    }
}

