/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.api.entity;

import java.net.URI;
import java.util.Objects;

public class InstanceEntity {
    private String appName;
    private String host;
    private Integer port;
    private URI uri;
    private int status;
    private int weight;

    public InstanceEntity(String appName, String host, Integer port) {
        this.appName = appName;
        this.host = host;
        this.port = port;
    }

    public InstanceEntity() {
    }

    private InstanceEntity(Builder builder) {
        this.appName = builder.appName;
        this.host = builder.host;
        this.port = builder.port;
        this.uri = builder.uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return Boolean.TRUE;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return Boolean.FALSE;
        }
        InstanceEntity that = (InstanceEntity)o;
        return Objects.equals(this.getAppName(), that.getAppName()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort());
    }

    public int hashCode() {
        return Objects.hash(this.getAppName(), this.getHost(), this.getPort());
    }

    public String toString() {
        return "URIRegisterDTO{appName='" + this.appName + ", host='" + this.host + ", port=" + this.port + "}";
    }

    public static final class Builder {
        private String appName;
        private String host;
        private Integer port;
        private URI uri;

        private Builder() {
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public InstanceEntity build() {
            return new InstanceEntity(this);
        }
    }
}

