/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.hessian2.Hessian2FactoryManager;
import org.apache.dubbo.common.serialize.hessian2.Hessian2ObjectInput;
import org.apache.dubbo.common.serialize.hessian2.Hessian2ObjectOutput;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Hessian2Serialization
implements Serialization {
    private static final Logger logger = LoggerFactory.getLogger(Hessian2Serialization.class);

    @Override
    public byte getContentTypeId() {
        return 2;
    }

    @Override
    public String getContentType() {
        return "x-application/hessian2";
    }

    @Override
    public ObjectOutput serialize(URL url, OutputStream out) throws IOException {
        Hessian2FactoryManager hessian2FactoryManager = Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(Hessian2FactoryManager.class);
        return new Hessian2ObjectOutput(out, hessian2FactoryManager);
    }

    @Override
    public ObjectInput deserialize(URL url, InputStream is) throws IOException {
        Hessian2FactoryManager hessian2FactoryManager = Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(Hessian2FactoryManager.class);
        return new Hessian2ObjectInput(is, hessian2FactoryManager);
    }

    static {
        Class<Hessian2Output> aClass = null;
        try {
            aClass = Hessian2Output.class;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (aClass == null) {
            logger.info("Failed to load com.alibaba.com.caucho.hessian.io.Hessian2Output, hessian2 serialization will be disabled.");
            throw new IllegalStateException("The hessian2 is not in classpath.");
        }
    }
}

