/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.config.global.ServerConnectorConfig;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.grpc.X509ManagerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;

public class ChannelTlsCertificates {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelTlsCertificates.class);
    private final X509TrustManager trustManager;
    private final X509KeyManager keyManager;

    public ChannelTlsCertificates(X509TrustManager trustManager, X509KeyManager keyManager) {
        this.trustManager = trustManager;
        this.keyManager = keyManager;
    }

    @Nullable
    public static ChannelTlsCertificates build(ServerConnectorConfig serverConnectorConfig) {
        try {
            X509TrustManager trustManager = null;
            X509KeyManager keyManager = null;
            if (ChannelTlsCertificates.hasTrustedCertificates(serverConnectorConfig)) {
                trustManager = X509ManagerUtil.buildTrustManager(ChannelTlsCertificates.readCertificateFileBytes(serverConnectorConfig.getTrustedCAFile()));
            }
            if (ChannelTlsCertificates.hasClientCertificates(serverConnectorConfig)) {
                keyManager = X509ManagerUtil.buildKeyManager(ChannelTlsCertificates.readCertificateFileBytes(serverConnectorConfig.getCertFile()), ChannelTlsCertificates.readCertificateFileBytes(serverConnectorConfig.getKeyFile()));
            }
            if (trustManager == null && keyManager == null) {
                return null;
            }
            return new ChannelTlsCertificates(trustManager, keyManager);
        }
        catch (SSLException e) {
            LOG.error("Build X.509 key/trust manager error. Return null.", (Throwable)e);
            return null;
        }
    }

    private static boolean hasTrustedCertificates(ServerConnectorConfig serverConnectorConfig) {
        return StringUtils.isNotEmpty(serverConnectorConfig.getTrustedCAFile());
    }

    private static boolean hasClientCertificates(ServerConnectorConfig serverConnectorConfig) {
        String keyFile = serverConnectorConfig.getKeyFile();
        String certFile = serverConnectorConfig.getCertFile();
        if (StringUtils.isEmpty(certFile) && StringUtils.isEmpty(keyFile)) {
            LOG.debug("The server connector configuration has no client certificates and key chain.");
            return false;
        }
        if (StringUtils.isNotEmpty(certFile) && StringUtils.isEmpty(keyFile)) {
            LOG.warn("The server connector configuration has client certificates but not client key chain");
            return false;
        }
        if (StringUtils.isEmpty(certFile) && StringUtils.isNotEmpty(keyFile)) {
            LOG.warn("The server connector configuration has client key chain but not client certificates");
            return false;
        }
        return true;
    }

    private static byte[] readCertificateFileBytes(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("Invalid Grpc tls certificate path: " + path);
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading certificate file: " + path, e);
        }
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }
}

