/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.tencent.polaris.configuration.api.core.ConfigFilePublishService;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import com.tencent.polaris.configuration.factory.ConfigFileServicePublishFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import java.util.Collections;
import org.apache.shenyu.admin.config.properties.PolarisProperties;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.polaris.PolarisDataChangedInit;
import org.apache.shenyu.admin.listener.polaris.PolarisDataChangedListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="shenyu.sync.polaris", name={"url"})
@EnableConfigurationProperties(value={PolarisProperties.class})
public class PolarisSyncConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConfigFileService.class})
    public ConfigFileService polarisConfigFileService(PolarisProperties polarisProperties) {
        com.tencent.polaris.api.config.Configuration configuration = ConfigAPIFactory.defaultConfig();
        configuration.getConfigFile().getServerConnector().setAddresses(Collections.singletonList(polarisProperties.getUrl()));
        return ConfigFileServiceFactory.createConfigFileService((com.tencent.polaris.api.config.Configuration)configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={ConfigFilePublishService.class})
    public ConfigFilePublishService polarisConfigFilePublishService(PolarisProperties polarisProperties) {
        com.tencent.polaris.api.config.Configuration configuration = ConfigAPIFactory.defaultConfig();
        configuration.getConfigFile().getServerConnector().setAddresses(Collections.singletonList(polarisProperties.getUrl()));
        return ConfigFileServicePublishFactory.createConfigFilePublishService((com.tencent.polaris.api.config.Configuration)configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={PolarisDataChangedListener.class})
    public DataChangedListener polarisDataChangedListener(PolarisProperties polarisProperties, ConfigFileService configFileService, ConfigFilePublishService configFilePublishService) {
        return new PolarisDataChangedListener(polarisProperties, configFileService, configFilePublishService);
    }

    @Bean
    @ConditionalOnMissingBean(value={PolarisDataChangedInit.class})
    public DataChangedInit polarisDataChangedInit(PolarisProperties polarisProperties, ConfigFileService configFileService) {
        return new PolarisDataChangedInit(polarisProperties, configFileService);
    }
}

