/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.resource;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class ResourceChangedEvent
extends AdminDataModelChangedEvent {
    public ResourceChangedEvent(ResourceDO source, ResourceDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        ResourceDO after = (ResourceDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the resource [%s] is %s", after.getTitle(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the resource [%s] is %s : %s", after.getTitle(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        ResourceDO before = (ResourceDO)this.getBefore();
        Objects.requireNonNull(before);
        ResourceDO after = (ResourceDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getName(), after.getName())) {
            builder.append(String.format("name[%s => %s] ", before.getName(), after.getName()));
        }
        if (!Objects.equals(before.getComponent(), after.getComponent())) {
            builder.append(String.format("component[%s => %s] ", before.getComponent(), after.getComponent()));
        }
        if (!Objects.equals(before.getIcon(), after.getIcon())) {
            builder.append(String.format("match icon[%s => %s] ", before.getIcon(), after.getIcon()));
        }
        if (!Objects.equals(before.getTitle(), after.getTitle())) {
            builder.append(String.format("title[%s => %s] ", before.getTitle(), after.getTitle()));
        }
        if (!Objects.equals(before.getSort(), after.getSort())) {
            builder.append(String.format("sort[%s => %s] ", before.getSort(), after.getSort()));
        }
        if (!Objects.equals(before.getPerms(), after.getPerms())) {
            builder.append(String.format("perms[%s => %s] ", before.getPerms(), after.getPerms()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "resource";
    }
}

