/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.RegistryMapper;
import org.apache.shenyu.admin.model.dto.RegistryDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.RegistryQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.RegistryVO;
import org.apache.shenyu.admin.service.impl.RegistryServiceImpl;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/registry"})
public class RegistryController {
    private final RegistryServiceImpl registryService;

    public RegistryController(RegistryServiceImpl registryService) {
        this.registryService = registryService;
    }

    @GetMapping(value={"/findPageByQuery"})
    @RequiresPermissions(value={"system:registry:list"})
    public ShenyuAdminResult findPageByQuery(String registryId, String address, String namespace, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        RegistryQuery query = new RegistryQuery();
        query.setRegistryId(registryId);
        query.setAddress(address);
        query.setNamespace(namespace);
        query.setPageParameter(new PageParameter(currentPage, pageSize));
        CommonPager<RegistryVO> commonPager = this.registryService.listByPage(query);
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system:registry:list"})
    public ShenyuAdminResult list() {
        return ShenyuAdminResult.success("query success", this.registryService.listAll());
    }

    @PostMapping(value={"/insertOrUpdate"})
    @RequiresPermissions(value={"system:registry:add", "system:registry:edit"}, logical=Logical.OR)
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody RegistryDTO registryDTO) {
        return ShenyuAdminResult.success("success", this.registryService.createOrUpdate(registryDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:registry:delete"})
    public ShenyuAdminResult delete(@RequestBody List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("success", this.registryService.delete(ids));
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:registry:edit"})
    public ShenyuAdminResult detailPlugin(@PathVariable(value="id") @Existed(message="id is not existed", provider=RegistryMapper.class) @Existed(message="id is not existed", provider=RegistryMapper.class) String id) {
        RegistryVO registryVO = this.registryService.findById(id);
        return ShenyuAdminResult.success("detail success", registryVO);
    }
}

