/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Optional;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.service.PermissionService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/permission"})
public class PermissionController {
    private final PermissionService permissionService;

    public PermissionController(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @GetMapping(value={"/getUserPermissionByToken"})
    public ShenyuAdminResult getUserPermissionByToken(@RequestParam(name="token", required=false) String token, @RequestParam(name="namespaceId", required=false) String namespaceId) {
        PermissionMenuVO permissionMenuVO = this.permissionService.getPermissionMenu(namespaceId);
        return Optional.ofNullable(permissionMenuVO).map(item -> ShenyuAdminResult.success("get menu and permission success", item)).orElseGet(() -> ShenyuAdminResult.error("get menu and permission failed"));
    }

    @GetMapping(value={"/getUserPermissionByNamespace"})
    public ShenyuAdminResult getUserPermissionByNamespace(@RequestParam(name="namespaceId", required=false) String namespaceId) {
        PermissionMenuVO permissionMenuVO = this.permissionService.getPermissionMenu(namespaceId);
        return Optional.ofNullable(permissionMenuVO).map(item -> ShenyuAdminResult.success("get menu and permission success", item)).orElseGet(() -> ShenyuAdminResult.error("get menu and permission failed"));
    }
}

