/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.selector;

import java.util.Objects;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;

public final class GrpcUpstream
extends CommonUpstream {
    private int weight;

    private GrpcUpstream(Builder builder) {
        boolean statusValue = builder.statusValue;
        if (!builder.statusSet) {
            statusValue = GrpcUpstream.defaultStatus();
        }
        this.setUpstreamHost(builder.upstreamHost);
        this.setProtocol(builder.protocol);
        this.setUpstreamUrl(builder.upstreamUrl);
        this.weight = builder.weight;
        this.setStatus(statusValue);
        this.setTimestamp(builder.timestamp);
        this.setNamespaceId(builder.namespaceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcUpstream that = (GrpcUpstream)o;
        return Objects.equals(this.getUpstreamHost(), that.getUpstreamHost()) && Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUpstreamUrl(), that.getUpstreamUrl()) && Objects.equals(this.getNamespaceId(), that.getNamespaceId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getUpstreamHost(), this.getProtocol(), this.getUpstreamUrl(), this.getNamespaceId());
    }

    @Override
    public String toString() {
        return "GrpcUpstream{upstreamHost='" + this.getUpstreamHost() + "', protocol='" + this.getProtocol() + "', upstreamUrl='" + this.getUpstreamUrl() + "', weight=" + this.weight + ", status=" + this.isStatus() + ", timestamp=" + this.getTimestamp() + ", namespaceId=" + this.getNamespaceId() + "}";
    }

    public static final class Builder {
        private String upstreamHost;
        private String protocol;
        private String upstreamUrl;
        private int weight;
        private boolean statusSet;
        private boolean statusValue;
        private long timestamp;
        private String namespaceId;

        private Builder() {
        }

        public GrpcUpstream build() {
            return new GrpcUpstream(this);
        }

        public Builder upstreamHost(String upstreamHost) {
            this.upstreamHost = upstreamHost;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder upstreamUrl(String upstreamUrl) {
            this.upstreamUrl = upstreamUrl;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder status(boolean status) {
            this.statusValue = status;
            this.statusSet = true;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }
    }
}

