/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.XmlXStream;
import com.netflix.discovery.provider.ISerializer;
import com.thoughtworks.xstream.XStream;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EntityBodyConverter
implements ISerializer {
    private static final String XML = "xml";
    private static final String JSON = "json";

    @Override
    public Object read(InputStream is, Class type, MediaType mediaType) throws IOException {
        XStream xstream = this.getXStreamInstance(mediaType);
        if (xstream != null) {
            return xstream.fromXML(is);
        }
        throw new IllegalArgumentException("Content-type: " + mediaType.getType() + " is currently not supported for " + type.getName());
    }

    @Override
    public void write(Object object, OutputStream os, MediaType mediaType) throws IOException {
        XStream xstream = this.getXStreamInstance(mediaType);
        if (xstream == null) {
            throw new IllegalArgumentException("Content-type: " + mediaType.getType() + " is currently not supported for " + object.getClass().getName());
        }
        xstream.toXML(object, os);
    }

    private XStream getXStreamInstance(MediaType mediaType) {
        XStream xstream = null;
        if (JSON.equalsIgnoreCase(mediaType.getSubtype())) {
            xstream = JsonXStream.getInstance();
        } else if (XML.equalsIgnoreCase(mediaType.getSubtype())) {
            xstream = XmlXStream.getInstance();
        }
        return xstream;
    }
}

