/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.transformer.HeaderFilter;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.util.Assert;

public class HeaderFilterSpec
extends ConsumerEndpointSpec<HeaderFilterSpec, MessageTransformingHandler> {
    private final HeaderFilter headerFilter;
    private final boolean headerFilterExplicitlySet;

    protected HeaderFilterSpec() {
        this(new HeaderFilter(), false);
    }

    protected HeaderFilterSpec(HeaderFilter headerFilter) {
        this(headerFilter, true);
    }

    private HeaderFilterSpec(HeaderFilter headerFilter, boolean headerFilterExplicitlySet) {
        super(new MessageTransformingHandler(headerFilter));
        this.headerFilter = headerFilter;
        this.componentsToRegister.put(this.headerFilter, null);
        this.headerFilterExplicitlySet = headerFilterExplicitlySet;
    }

    public HeaderFilterSpec headersToRemove(String ... headersToRemove) {
        this.assertHeaderFilterNotExplicitlySet();
        this.headerFilter.setHeadersToRemove(headersToRemove);
        return this;
    }

    public HeaderFilterSpec patternMatch(boolean patternMatch) {
        this.assertHeaderFilterNotExplicitlySet();
        this.headerFilter.setPatternMatch(patternMatch);
        return this;
    }

    private void assertHeaderFilterNotExplicitlySet() {
        Assert.isTrue((!this.headerFilterExplicitlySet ? 1 : 0) != 0, () -> "Cannot override already set header filter: " + this.headerFilter);
    }
}

