/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpServerFeatures {

    public record SyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpSyncServerExchange, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler) {
    }

    public record SyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpSyncServerExchange, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
    }

    public record SyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpSyncServerExchange, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record SyncToolSpecification(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> call) {
    }

    public record AsyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpAsyncServerExchange, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> completionHandler) {
        static AsyncCompletionSpecification fromSync(SyncCompletionSpecification completion) {
            if (completion == null) {
                return null;
            }
            return new AsyncCompletionSpecification(completion.referenceKey(), (exchange, request) -> Mono.fromCallable(() -> completion.completionHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.CompleteRequest)request)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
        static AsyncPromptSpecification fromSync(SyncPromptSpecification prompt) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptSpecification(prompt.prompt(), (exchange, req) -> Mono.fromCallable(() -> prompt.promptHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.GetPromptRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceSpecification fromSync(SyncResourceSpecification resource) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceSpecification(resource.resource(), (exchange, req) -> Mono.fromCallable(() -> resource.readHandler().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (McpSchema.ReadResourceRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncToolSpecification(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
        static AsyncToolSpecification fromSync(SyncToolSpecification tool) {
            if (tool == null) {
                return null;
            }
            return new AsyncToolSpecification(tool.tool(), (exchange, map) -> Mono.fromCallable(() -> tool.call().apply(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (Map<String, Object>)map)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    record Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers, String instructions) {
        Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.completions = completions != null ? completions : new HashMap();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : new ArrayList();
            this.instructions = instructions;
        }
    }

    record Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers, String instructions) {
        Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : List.of();
            this.resources = resources != null ? resources : Map.of();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : List.of();
            this.prompts = prompts != null ? prompts : Map.of();
            this.completions = completions != null ? completions : Map.of();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : List.of();
            this.instructions = instructions;
        }

        static Async fromSync(Sync syncSpec) {
            ArrayList<AsyncToolSpecification> tools = new ArrayList<AsyncToolSpecification>();
            for (SyncToolSpecification tool : syncSpec.tools()) {
                tools.add(AsyncToolSpecification.fromSync(tool));
            }
            HashMap<String, AsyncResourceSpecification> resources = new HashMap<String, AsyncResourceSpecification>();
            syncSpec.resources().forEach((key, resource) -> resources.put((String)key, AsyncResourceSpecification.fromSync(resource)));
            HashMap<String, AsyncPromptSpecification> prompts = new HashMap<String, AsyncPromptSpecification>();
            syncSpec.prompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptSpecification.fromSync(prompt)));
            HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification>();
            syncSpec.completions().forEach((key, completion) -> completions.put((McpSchema.CompleteReference)key, AsyncCompletionSpecification.fromSync(completion)));
            ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootChangeConsumers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();
            for (BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> rootChangeConsumer : syncSpec.rootsChangeConsumers()) {
                rootChangeConsumers.add((exchange, list) -> Mono.fromRunnable(() -> rootChangeConsumer.accept(new McpSyncServerExchange((McpAsyncServerExchange)exchange), (List<McpSchema.Root>)list)).subscribeOn(Schedulers.boundedElastic()));
            }
            return new Async(syncSpec.serverInfo(), syncSpec.serverCapabilities(), tools, resources, syncSpec.resourceTemplates(), prompts, completions, rootChangeConsumers, syncSpec.instructions());
        }
    }
}

