/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.definition;

import org.apache.commons.lang3.StringUtils;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.util.Assert;

public class ShenyuToolDefinition
implements ToolDefinition {
    private final String name;
    private final String description;
    private final String requestConfig;
    private final String inputSchema;

    public ShenyuToolDefinition(String name, String description, String requestConfig, String inputSchema) {
        Assert.hasText((String)name, (String)"name cannot be null or empty");
        Assert.hasText((String)description, (String)"description cannot be null or empty");
        Assert.hasText((String)requestConfig, (String)"requestTemplate cannot be null or empty");
        Assert.hasText((String)inputSchema, (String)"inputSchema cannot be null or empty");
        this.name = name;
        this.description = description;
        this.inputSchema = inputSchema;
        this.requestConfig = requestConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String inputSchema() {
        return this.inputSchema;
    }

    public String requestConfig() {
        return this.requestConfig;
    }

    public static final class Builder {
        private String name;
        private String description;
        private String requestConfig;
        private String inputSchema;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder requestConfig(String requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        public Builder inputSchema(String inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public ToolDefinition build() {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.description})) {
                this.description = ToolUtils.getToolDescriptionFromName((String)this.name);
            }
            return new ShenyuToolDefinition(this.name, this.description, this.requestConfig, this.inputSchema);
        }
    }
}

