/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeFloat32;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeInt64;
import com.weibo.breeze.type.TypeString;

public class TypeFloat64
implements BreezeType<Double> {
    TypeFloat64() {
    }

    public static double readFloat64(BreezeBuffer buffer) {
        return buffer.getDouble();
    }

    @Override
    public byte getType() {
        return -96;
    }

    @Override
    public Double read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (!withType) {
            return TypeFloat64.readFloat64(buffer);
        }
        byte type = buffer.get();
        switch (type) {
            case -96: {
                return TypeFloat64.readFloat64(buffer);
            }
            case -97: {
                return TypeFloat32.readFloat32(buffer);
            }
            case 63: {
                return Double.parseDouble(TypeString.readString(buffer));
            }
            case 127: {
                return TypeInt32.readInt32(buffer);
            }
            case -104: {
                return TypeInt64.readInt64(buffer);
            }
        }
        throw new BreezeException("Breeze cannot convert to Double. type: " + type);
    }

    @Override
    public void write(BreezeBuffer buffer, Double value, boolean withType) throws BreezeException {
        if (withType) {
            buffer.put((byte)-96);
        }
        buffer.putDouble(value);
    }

    @Override
    public void writeMessageField(BreezeBuffer buffer, int index, Double field, boolean withType, boolean checkDefault) throws BreezeException {
        if (field != null) {
            if (checkDefault && field == 0.0) {
                return;
            }
            buffer.putVarint(index);
            this.write(buffer, field, withType);
        }
    }
}

