/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.condition.judge;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.plugin.base.condition.judge.BlankPredicateJudge;
import org.apache.shenyu.plugin.base.condition.judge.PredicateJudge;
import org.apache.shenyu.spi.ExtensionLoader;

public final class PredicateJudgeFactory {
    private PredicateJudgeFactory() {
    }

    public static PredicateJudge newInstance(String operator) {
        return (PredicateJudge)ExtensionLoader.getExtensionLoader(PredicateJudge.class).getJoin(PredicateJudgeFactory.processSpecialOperator(operator));
    }

    public static Boolean judge(ConditionData conditionData, String realData) {
        if (Objects.isNull(conditionData) || StringUtils.isBlank((CharSequence)conditionData.getOperator())) {
            return false;
        }
        PredicateJudge predicateJudge = PredicateJudgeFactory.newInstance(conditionData.getOperator());
        if (!(predicateJudge instanceof BlankPredicateJudge) && StringUtils.isBlank((CharSequence)realData)) {
            return false;
        }
        return predicateJudge.judge(conditionData, realData);
    }

    private static String processSpecialOperator(String operator) {
        return "=".equals(operator) ? "equals" : operator;
    }
}

