/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.response;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.response.ResponsePlugin;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.apache.shenyu.plugin.response.strategy.NettyClientMessageWriter;
import org.apache.shenyu.plugin.response.strategy.RPCMessageWriter;
import org.apache.shenyu.plugin.response.strategy.WebClientMessageWriter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.response.enabled"}, havingValue="true", matchIfMissing=true)
public class ResponsePluginConfiguration {
    @Bean
    public ShenyuPlugin responsePlugin(ObjectProvider<List<MessageWriter>> httpWriter) {
        LinkedHashMap<String, MessageWriter> writerMap = new LinkedHashMap<String, MessageWriter>();
        List writerList = (List)httpWriter.getIfAvailable(ArrayList::new);
        for (MessageWriter writer : writerList) {
            List supportTypes = writer.supportTypes();
            for (String type : supportTypes) {
                writerMap.put(type, writer);
            }
        }
        return new ResponsePlugin(writerMap);
    }

    @Bean
    @ConditionalOnProperty(name={"shenyu.plugins.response.rpc-message-writer"}, havingValue="true", matchIfMissing=true)
    public MessageWriter rpcMessageWriter() {
        return new RPCMessageWriter();
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="netty", matchIfMissing=true)
    static class NettyClientMessageWriterConfiguration {
        NettyClientMessageWriterConfiguration() {
        }

        @Bean
        public MessageWriter nettyMessageWriter() {
            return new NettyClientMessageWriter();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="webClient")
    static class WebClientMessageWriterConfiguration {
        WebClientMessageWriterConfiguration() {
        }

        @Bean
        public MessageWriter webClientMessageWriter() {
            return new WebClientMessageWriter();
        }
    }
}

