/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api.composite;

import com.alipay.lookout.api.Clock;
import com.alipay.lookout.api.Counter;
import com.alipay.lookout.api.DistributionSummary;
import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Metric;
import com.alipay.lookout.api.NoopMixinMetric;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.Timer;
import com.alipay.lookout.api.composite.CompositeCounter;
import com.alipay.lookout.api.composite.CompositeDistributionSummary;
import com.alipay.lookout.api.composite.CompositeMetric;
import com.alipay.lookout.api.composite.CompositeTimer;
import com.alipay.lookout.api.composite.MixinMetric;
import java.util.Collection;

class CompositeMixinMetric
extends CompositeMetric
implements MixinMetric {
    private final Clock clock;

    public CompositeMixinMetric(Id id, Clock clock, Collection<Registry> registries) {
        super(id, registries);
        this.clock = clock;
    }

    @Override
    public Counter counter(String componentCounterName) {
        return new CompositeComponentCounter(this.id, this.registries, componentCounterName);
    }

    @Override
    public Timer timer(String componentTimerName) {
        return new CompositeComponentTimer(this.id, this.clock, this.registries, componentTimerName);
    }

    @Override
    public DistributionSummary distributionSummary(String componentDistributionSummaryName) {
        return new CompositeComponentDistributionSummary(this.id, this.registries, componentDistributionSummaryName);
    }

    @Override
    public <T extends Number> Gauge<T> gauge(String componentGaugeName, Gauge<T> componentGauge) {
        Gauge<T> old = null;
        for (Registry registry : this.registries) {
            MixinMetric mixinMetric = registry.mixinMetric(this.id);
            if (mixinMetric == null) continue;
            Gauge<T> oldOne = mixinMetric.gauge(componentGaugeName, componentGauge);
            if (old != null || oldOne == null) continue;
            old = oldOne;
        }
        return old;
    }

    @Override
    protected <T extends Metric> T getMetric(Registry registry) {
        throw new UnsupportedOperationException();
    }

    private MixinMetric getMixinMetric(Registry registry) {
        MixinMetric metric = registry.mixinMetric(this.id());
        return metric == null ? NoopMixinMetric.INSTANCE : metric;
    }

    class CompositeComponentTimer
    extends CompositeTimer {
        private String componentMetricName;

        public CompositeComponentTimer(Id id, Clock clock, Collection<Registry> registries, String componentMetricName) {
            super(id, clock, registries);
            this.componentMetricName = componentMetricName;
        }

        @Override
        protected Timer getMetric(Registry registry) {
            MixinMetric mixinMetric = CompositeMixinMetric.this.getMixinMetric(registry);
            return mixinMetric.timer(this.componentMetricName);
        }
    }

    class CompositeComponentDistributionSummary
    extends CompositeDistributionSummary {
        private String componentMetricName;

        public CompositeComponentDistributionSummary(Id id, Collection<Registry> registries, String componentMetricName) {
            super(id, registries);
            this.componentMetricName = componentMetricName;
        }

        @Override
        protected DistributionSummary getMetric(Registry registry) {
            MixinMetric mixinMetric = CompositeMixinMetric.this.getMixinMetric(registry);
            return mixinMetric.distributionSummary(this.componentMetricName);
        }
    }

    class CompositeComponentCounter
    extends CompositeCounter {
        private String componentMetricName;

        public CompositeComponentCounter(Id id, Collection<Registry> registries, String componentMetricName) {
            super(id, registries);
            this.componentMetricName = componentMetricName;
        }

        @Override
        protected Counter getMetric(Registry registry) {
            MixinMetric mixinMetric = CompositeMixinMetric.this.getMixinMetric(registry);
            return mixinMetric.counter(this.componentMetricName);
        }
    }
}

