/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.DynamicMessage;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.grpc.exception.ShenyuGrpcException;
import org.apache.shenyu.plugin.grpc.proto.CompleteObserver;
import org.apache.shenyu.plugin.grpc.proto.CompositeStreamObserver;
import org.apache.shenyu.plugin.grpc.proto.MessageWriter;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcCallRequest;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcResponse;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuGrpcClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuGrpcClient.class);
    private final ManagedChannel channel;

    public ShenyuGrpcClient(ManagedChannel channel) {
        this.channel = channel;
    }

    public CompletableFuture<ShenyuGrpcResponse> call(MetaData metaData, CallOptions callOptions, String requestJsons, MethodDescriptor.MethodType methodType) {
        List jsonRequestList = JsonMessage.buildJsonMessageList((Map)GsonUtils.getInstance().toObjectMap(requestJsons));
        DynamicMessage jsonResponse = JsonMessage.buildJsonMessage();
        MethodDescriptor jsonMarshallerMethodDescriptor = JsonMessage.createJsonMarshallerMethodDescriptor((String)metaData.getServiceName(), (String)metaData.getMethodName(), (MethodDescriptor.MethodType)methodType, (DynamicMessage)((DynamicMessage)jsonRequestList.get(0)), (DynamicMessage)jsonResponse);
        ShenyuGrpcResponse shenyuGrpcResponse = new ShenyuGrpcResponse();
        MessageWriter<DynamicMessage> streamObserver = MessageWriter.newInstance(shenyuGrpcResponse);
        ShenyuGrpcCallRequest callParams = new ShenyuGrpcCallRequest();
        callParams.setMethodDescriptor((MethodDescriptor<DynamicMessage, DynamicMessage>)jsonMarshallerMethodDescriptor);
        callParams.setChannel((Channel)this.channel);
        callParams.setCallOptions(callOptions);
        callParams.setResponseObserver(streamObserver);
        callParams.setRequests(jsonRequestList);
        try {
            this.invoke(callParams).get();
        }
        catch (InterruptedException e) {
            LOG.error("Grpc plugin invoke method is exception, Will cause the thread to be interrupted");
            Thread.currentThread().interrupt();
            throw new ShenyuGrpcException("Caught exception while waiting for rpc :{ " + e.getMessage() + "}", e);
        }
        catch (ExecutionException e) {
            throw new ShenyuGrpcException("Caught exception while waiting for rpc :{ " + e.getMessage() + "}", e);
        }
        return CompletableFuture.completedFuture(shenyuGrpcResponse);
    }

    public ListenableFuture<Void> invoke(ShenyuGrpcCallRequest callParams) {
        MethodDescriptor.MethodType methodType = callParams.getMethodDescriptor().getType();
        List<DynamicMessage> requestList = callParams.getRequests();
        StreamObserver<DynamicMessage> responseObserver = callParams.getResponseObserver();
        CompleteObserver doneObserver = new CompleteObserver();
        CompositeStreamObserver<DynamicMessage> compositeObserver = CompositeStreamObserver.of(responseObserver, doneObserver);
        switch (methodType) {
            case UNARY: {
                ClientCalls.asyncUnaryCall(this.createCall(callParams), (Object)requestList.get(0), compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case SERVER_STREAMING: {
                ClientCalls.asyncServerStreamingCall(this.createCall(callParams), (Object)requestList.get(0), compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case CLIENT_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncClientStreamingCall(this.createCall(callParams), compositeObserver);
                requestList.forEach(arg_0 -> ((StreamObserver)requestObserver).onNext(arg_0));
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
            case BIDI_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncBidiStreamingCall(this.createCall(callParams), compositeObserver);
                requestList.forEach(arg_0 -> ((StreamObserver)requestObserver).onNext(arg_0));
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
        }
        LOG.info("Unknown methodType:{}", (Object)methodType);
        return null;
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }

    private ClientCall<DynamicMessage, DynamicMessage> createCall(ShenyuGrpcCallRequest callParams) {
        return callParams.getChannel().newCall(callParams.getMethodDescriptor(), callParams.getCallOptions());
    }
}

