/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.transformer.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.plugin.AiResponseTransformerConfig;
import org.apache.shenyu.common.dto.convert.rule.AiResponseTransformerHandle;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.common.spring.ai.registry.AiModelFactoryRegistry;
import org.apache.shenyu.plugin.ai.transformer.response.cache.ChatClientCache;
import org.apache.shenyu.plugin.ai.transformer.response.handler.AiResponseTransformerPluginHandler;
import org.apache.shenyu.plugin.ai.transformer.response.template.AiResponseTransformerTemplate;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AiResponseTransformerPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AiResponseTransformerPlugin.class);
    private final List<HttpMessageReader<?>> messageReaders;
    private final AiModelFactoryRegistry aiModelFactoryRegistry;

    public AiResponseTransformerPlugin(List<HttpMessageReader<?>> messageReaders, AiModelFactoryRegistry aiModelFactoryRegistry) {
        this.messageReaders = messageReaders;
        this.aiModelFactoryRegistry = aiModelFactoryRegistry;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String provider;
        String apiKey;
        String baseUrl;
        AiResponseTransformerConfig aiResponseTransformerConfig = (AiResponseTransformerConfig)Singleton.INST.get(AiResponseTransformerConfig.class);
        if (Objects.isNull(aiResponseTransformerConfig)) {
            aiResponseTransformerConfig = new AiResponseTransformerConfig();
        }
        AiResponseTransformerHandle aiResponseTransformerHandle = (AiResponseTransformerHandle)AiResponseTransformerPluginHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        ChatClient client = ChatClientCache.getInstance().getClient("default");
        if (Objects.nonNull(aiResponseTransformerHandle)) {
            aiResponseTransformerConfig = new AiResponseTransformerConfig();
            Optional.ofNullable(aiResponseTransformerHandle.getProvider()).ifPresent(arg_0 -> ((AiResponseTransformerConfig)aiResponseTransformerConfig).setProvider(arg_0));
            Optional.ofNullable(aiResponseTransformerHandle.getBaseUrl()).ifPresent(arg_0 -> ((AiResponseTransformerConfig)aiResponseTransformerConfig).setBaseUrl(arg_0));
            Optional.ofNullable(aiResponseTransformerHandle.getApiKey()).ifPresent(arg_0 -> ((AiResponseTransformerConfig)aiResponseTransformerConfig).setApiKey(arg_0));
            Optional.ofNullable(aiResponseTransformerHandle.getModel()).ifPresent(arg_0 -> ((AiResponseTransformerConfig)aiResponseTransformerConfig).setModel(arg_0));
            Optional.ofNullable(aiResponseTransformerHandle.getContent()).ifPresent(arg_0 -> ((AiResponseTransformerConfig)aiResponseTransformerConfig).setContent(arg_0));
            client = ChatClientCache.getInstance().getClient(rule.getId());
        }
        if (Stream.of(baseUrl = aiResponseTransformerConfig.getBaseUrl(), apiKey = aiResponseTransformerConfig.getApiKey(), provider = aiResponseTransformerConfig.getProvider()).anyMatch(Objects::isNull)) {
            Object missing = "";
            missing = (String)missing + (Objects.isNull(baseUrl) ? "baseUrl, " : "");
            missing = (String)missing + (Objects.isNull(apiKey) ? "apiKey, " : "");
            missing = (String)missing + (Objects.isNull(provider) ? "provider, " : "");
            LOG.error("Missing configurations: {}", (Object)((String)missing).substring(0, ((String)missing).length() - 2));
            return chain.execute(exchange);
        }
        if (Objects.isNull(client)) {
            ChatModel aiModel = this.aiModelFactoryRegistry.getFactory(AiModelProviderEnum.getByName((String)provider)).createAiModel(AiResponseTransformerPluginHandler.convertConfig(aiResponseTransformerConfig));
            client = ChatClientCache.getInstance().init(rule.getId(), aiModel);
        }
        ChatClient finalClient = client;
        AiResponseTransformerTemplate aiResponseTransformerTemplate = new AiResponseTransformerTemplate(aiResponseTransformerConfig.getContent(), exchange.getRequest());
        return chain.execute(exchange.mutate().response((ServerHttpResponse)new AiResponseTransformerDecorator(exchange, aiResponseTransformerTemplate, finalClient)).build());
    }

    public int getOrder() {
        return PluginEnum.AI_RESPONSE_TRANSFORMER.getCode();
    }

    public String named() {
        return PluginEnum.AI_RESPONSE_TRANSFORMER.getName();
    }

    public static String extractBodyFromAiResponse(String aiResponse) {
        return AiResponseParser.extractBodyFromAiResponse(aiResponse);
    }

    public static HttpHeaders extractHeadersFromAiResponse(String aiResponse) {
        return AiResponseParser.extractHeadersFromAiResponse(aiResponse);
    }

    static class AiResponseTransformerDecorator
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final AiResponseTransformerTemplate aiResponseTransformerTemplate;
        private final ChatClient chatClient;

        AiResponseTransformerDecorator(ServerWebExchange exchange, AiResponseTransformerTemplate aiResponseTransformerTemplate, ChatClient chatClient) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.aiResponseTransformerTemplate = aiResponseTransformerTemplate;
            this.chatClient = chatClient;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            Mono dataBufferMono = DataBufferUtils.join(body);
            return dataBufferMono.flatMap(dataBuffer -> {
                byte[] bytes = new byte[dataBuffer.readableByteCount()];
                dataBuffer.read(bytes);
                DataBufferUtils.release((DataBuffer)dataBuffer);
                String originalResponseBody = new String(bytes, StandardCharsets.UTF_8);
                String contentEncoding = this.exchange.getResponse().getHeaders().getFirst("Content-Encoding");
                if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    LOG.debug("Detected gzip encoding, attempting to decompress");
                    try {
                        int len;
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        GZIPInputStream gis = new GZIPInputStream(bis);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len = gis.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                        }
                        gis.close();
                        bos.close();
                        originalResponseBody = bos.toString(StandardCharsets.UTF_8.name());
                        LOG.debug("Decompressed response body: {}", (Object)originalResponseBody);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to decompress gzip response", (Throwable)e);
                    }
                }
                String finalResponseBody = originalResponseBody;
                return this.aiResponseTransformerTemplate.assembleMessage(this.exchange).flatMap(message -> {
                    String messageWithResponseBody;
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        JsonNode messageNode = objectMapper.readTree(message);
                        if (messageNode.has("response") && messageNode.get("response").isObject()) {
                            ObjectNode responseNode = (ObjectNode)messageNode.get("response");
                            responseNode.put("body", finalResponseBody);
                        }
                        messageWithResponseBody = objectMapper.writeValueAsString((Object)messageNode);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to update message with response body", (Throwable)e);
                        messageWithResponseBody = message.replace("\"body\":\"\"", "\"body\":\"" + finalResponseBody.replace("\"", "\\\"") + "\"");
                        LOG.info("Fallback message with response body: {}", (Object)messageWithResponseBody);
                    }
                    String finalMessage = messageWithResponseBody;
                    return Mono.fromCallable(() -> this.chatClient.prompt().user(finalMessage).call().content()).subscribeOn(Schedulers.boundedElastic()).flatMap(aiResponse -> {
                        HttpHeaders newHeaders = this.extractHeadersFromAiResponse((String)aiResponse);
                        String newBody = this.extractBodyFromAiResponse((String)aiResponse);
                        this.getHeaders().clear();
                        this.getHeaders().putAll((Map)newHeaders);
                        if (Objects.nonNull(newBody) && !newBody.isEmpty()) {
                            LOG.debug("Returning transformed response body: {}", (Object)newBody);
                            return WebFluxResultUtils.result((ServerWebExchange)this.exchange, (Object)newBody.getBytes(StandardCharsets.UTF_8));
                        }
                        LOG.warn("response body is empty or null, returning original response: {}", (Object)finalResponseBody);
                        return WebFluxResultUtils.result((ServerWebExchange)this.exchange, (Object)finalResponseBody.getBytes(StandardCharsets.UTF_8));
                    }).onErrorResume(throwable -> {
                        LOG.error("response transformation failed", throwable);
                        LOG.info("Returning original response due to error: {}", (Object)finalResponseBody);
                        return WebFluxResultUtils.result((ServerWebExchange)this.exchange, (Object)finalResponseBody.getBytes(StandardCharsets.UTF_8));
                    });
                });
            });
        }

        private String extractBodyFromAiResponse(String aiResponse) {
            if (Objects.isNull(aiResponse) || aiResponse.isEmpty()) {
                LOG.warn("response is null or empty");
                return null;
            }
            String result = AiResponseParser.extractBodyFromAiResponse(aiResponse);
            if (Objects.isNull(result)) {
                LOG.warn("Could not extract body from AI response");
            } else {
                LOG.debug("Successfully extracted body from AI response: {}", (Object)result);
            }
            return result;
        }

        private HttpHeaders extractHeadersFromAiResponse(String aiResponse) {
            if (Objects.isNull(aiResponse) || aiResponse.isEmpty()) {
                LOG.warn("AI response is null or empty for header extraction");
                return new HttpHeaders();
            }
            HttpHeaders headers = AiResponseParser.extractHeadersFromAiResponse(aiResponse);
            LOG.debug("Extracted {} headers: {}", (Object)headers.size(), (Object)headers);
            return headers;
        }
    }

    private static class AiResponseParser {
        private AiResponseParser() {
        }

        static String extractBodyFromAiResponse(String aiResponse) {
            if (Objects.isNull(aiResponse) || aiResponse.isEmpty()) {
                return null;
            }
            String cleanedResponse = aiResponse;
            if (cleanedResponse.contains("```")) {
                int startIndex = cleanedResponse.indexOf("```");
                int endIndex = cleanedResponse.lastIndexOf("```");
                if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                    cleanedResponse = cleanedResponse.substring(startIndex + 3, endIndex).trim();
                    LOG.debug("Removed code block markers, cleaned response: {}", (Object)cleanedResponse);
                }
            }
            if (cleanedResponse.startsWith("{") && cleanedResponse.endsWith("}") || cleanedResponse.startsWith("[") && cleanedResponse.endsWith("]")) {
                return cleanedResponse;
            }
            String[] lines = cleanedResponse.split("\\R");
            int emptyLineIndex = -1;
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].trim().isEmpty()) continue;
                emptyLineIndex = i;
                break;
            }
            if (emptyLineIndex == -1 || emptyLineIndex == lines.length - 1) {
                return null;
            }
            StringBuilder bodyBuilder = new StringBuilder();
            for (int i = emptyLineIndex + 1; i < lines.length; ++i) {
                bodyBuilder.append(lines[i]);
                if (i >= lines.length - 1) continue;
                bodyBuilder.append("\n");
            }
            String body = bodyBuilder.toString().trim();
            if (body.startsWith("{") && body.endsWith("}") || body.startsWith("[") && body.endsWith("]")) {
                try {
                    new ObjectMapper().readTree(body);
                    return body;
                }
                catch (Exception e) {
                    LOG.warn("Body is not valid JSON: {}", (Object)body);
                    return null;
                }
            }
            return null;
        }

        static HttpHeaders extractHeadersFromAiResponse(String aiResponse) {
            HttpHeaders headers = new HttpHeaders();
            if (Objects.isNull(aiResponse) || aiResponse.isEmpty()) {
                return headers;
            }
            String cleanedResponse = aiResponse;
            if (cleanedResponse.contains("```")) {
                int startIndex = cleanedResponse.indexOf("```");
                int endIndex = cleanedResponse.lastIndexOf("```");
                if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                    cleanedResponse = cleanedResponse.substring(startIndex + 3, endIndex).trim();
                    LOG.debug("Removed code block markers for header extraction, cleaned response: {}", (Object)cleanedResponse);
                }
            }
            try (BufferedReader reader = new BufferedReader(new StringReader(cleanedResponse));){
                String line;
                boolean headerSectionStarted = false;
                while (Objects.nonNull(line = reader.readLine())) {
                    if (!headerSectionStarted) {
                        if (!line.startsWith("HTTP/1.1") && !line.matches("^(GET|POST|PUT|DELETE|PATCH|OPTIONS|HEAD)\\s.*\\sHTTP/1.1$")) continue;
                        headerSectionStarted = true;
                        continue;
                    }
                    if (line.trim().isEmpty()) {
                        break;
                    }
                    int colonIndex = line.indexOf(":");
                    if (colonIndex <= 0) continue;
                    String name = line.substring(0, colonIndex).trim();
                    String value = line.substring(colonIndex + 1).trim();
                    headers.add(name, value);
                }
            }
            catch (IOException e) {
                LOG.error("AI response transformer plugin: extract headers from AiResponse fail");
            }
            return headers;
        }
    }
}

