/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.request.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.RequestHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class RequestPluginHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, RequestHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            RequestHandle requestHandle = (RequestHandle)GsonUtils.getInstance().fromJson(s, RequestHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)requestHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.REQUEST.getName();
    }
}

