/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.Url;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.bolt.BoltClientConnectionManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

class ReuseBoltClientConnectionManager
extends BoltClientConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReuseBoltClientConnectionManager.class);
    final ConcurrentMap<ClientTransportConfig, Connection> urlConnectionMap = new ConcurrentHashMap<ClientTransportConfig, Connection>();
    final ConcurrentMap<Connection, AtomicInteger> connectionRefCounter = new ConcurrentHashMap<Connection, AtomicInteger>();

    public ReuseBoltClientConnectionManager(boolean addHook) {
        super(addHook);
    }

    @Override
    protected void checkLeak() {
        if (CommonUtils.isNotEmpty(this.urlConnectionMap)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Bolt client transport maybe leak. {}", this.urlConnectionMap);
            }
            this.urlConnectionMap.clear();
        }
        if (CommonUtils.isNotEmpty(this.connectionRefCounter)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Bolt client transport maybe leak. {}", this.connectionRefCounter);
            }
            this.connectionRefCounter.clear();
        }
    }

    @Override
    public Connection getConnection(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        if (rpcClient == null || transportConfig == null || url == null) {
            return null;
        }
        Connection connection = (Connection)this.urlConnectionMap.get(transportConfig);
        if (connection != null && !connection.isFine()) {
            this.closeConnection(rpcClient, transportConfig, url);
            connection = null;
        }
        if (connection == null) {
            try {
                connection = rpcClient.getConnection(url, url.getConnectTimeout());
            }
            catch (Exception e) {
                LOGGER.warn("get connection failed in url," + url, e);
            }
            if (connection == null) {
                return null;
            }
            Connection oldConnection = this.urlConnectionMap.putIfAbsent(transportConfig, connection);
            if (oldConnection != null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Multiple threads init ClientTransport with same key:" + url);
                }
                if (connection != oldConnection) {
                    rpcClient.closeStandaloneConnection(connection);
                    connection = oldConnection;
                }
            } else {
                AtomicInteger oldCounter;
                AtomicInteger counter = (AtomicInteger)this.connectionRefCounter.get(connection);
                if (counter == null && (oldCounter = this.connectionRefCounter.putIfAbsent(connection, counter = new AtomicInteger(0))) != null) {
                    counter = oldCounter;
                }
                int currentCount = counter.incrementAndGet();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Bolt client transport {} of {}, current ref count is: {}", url.toString(), NetUtils.channelToString(connection.getLocalAddress(), connection.getRemoteAddress()), currentCount);
                }
            }
        }
        return connection;
    }

    @Override
    public void closeConnection(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        boolean needDestroy;
        if (rpcClient == null || transportConfig == null || url == null) {
            return;
        }
        Connection connection = (Connection)this.urlConnectionMap.remove(transportConfig);
        if (connection == null) {
            return;
        }
        AtomicInteger integer = (AtomicInteger)this.connectionRefCounter.get(connection);
        if (integer == null) {
            needDestroy = true;
        } else {
            int currentCount = integer.decrementAndGet();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Client transport {} of {} , current ref count is: {}", url.toString(), NetUtils.channelToString(connection.getLocalAddress(), connection.getRemoteAddress()), currentCount);
            }
            if (currentCount <= 0) {
                this.connectionRefCounter.remove(connection);
                needDestroy = true;
            } else {
                needDestroy = false;
            }
        }
        if (needDestroy) {
            rpcClient.closeStandaloneConnection(connection);
        }
    }

    @Override
    public boolean isConnectionFine(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        Connection connection = this.getConnection(rpcClient, transportConfig, url);
        return connection != null && connection.isFine();
    }
}

