/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.rest;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.JAXRSProviderManager;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.proxy.ProxyFactory;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.rest.SofaNettyJaxrsServer;
import com.alipay.sofa.rpc.server.rest.SofaResourceFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.resteasy.plugins.interceptors.CorsFilter;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Extension(value="rest")
public class RestServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServer.class);
    protected volatile boolean started;
    protected SofaNettyJaxrsServer httpServer;
    protected ServerConfig serverConfig;
    protected AtomicInteger invokerCnt = new AtomicInteger();

    @Override
    public void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.httpServer = this.buildServer();
    }

    protected SofaNettyJaxrsServer buildServer() {
        SofaNettyJaxrsServer httpServer = new SofaNettyJaxrsServer(this.serverConfig);
        int bossThreads = this.serverConfig.getIoThreads();
        if (bossThreads > 0) {
            httpServer.setIoWorkerCount(bossThreads);
        }
        httpServer.setExecutorThreadCount(this.serverConfig.getMaxThreads());
        httpServer.setMaxRequestSize(this.serverConfig.getPayload());
        httpServer.setHostname(this.serverConfig.getBoundHost());
        httpServer.setPort(this.serverConfig.getPort());
        ResteasyDeployment resteasyDeployment = httpServer.getDeployment();
        resteasyDeployment.start();
        ResteasyProviderFactory providerFactory = resteasyDeployment.getProviderFactory();
        this.registerProvider(providerFactory);
        return httpServer;
    }

    protected void registerProvider(ResteasyProviderFactory providerFactory) {
        Set<Object> customProviderInstances;
        String crossDomainStr;
        Map<String, String> parameters;
        Set<Class> internalProviderClasses = JAXRSProviderManager.getInternalProviderClasses();
        if (CommonUtils.isNotEmpty(internalProviderClasses)) {
            for (Class providerClass : internalProviderClasses) {
                providerFactory.register(providerClass);
            }
        }
        if (CommonUtils.isNotEmpty(parameters = this.serverConfig.getParameters()) && StringUtils.isNotBlank(crossDomainStr = parameters.get("allowedOrigins"))) {
            CorsFilter corsFilter = new CorsFilter();
            String[] stringArray = StringUtils.splitWithCommaOrSemicolon(crossDomainStr);
            for (String allowDomain : stringArray) {
                corsFilter.getAllowedOrigins().add(allowDomain);
            }
            JAXRSProviderManager.registerCustomProviderInstance(corsFilter);
        }
        if (CommonUtils.isNotEmpty(customProviderInstances = JAXRSProviderManager.getCustomProviderInstances())) {
            for (Object e : customProviderInstances) {
                PropertyInjector propertyInjector = providerFactory.getInjectorFactory().createPropertyInjector(JAXRSProviderManager.getTargetClass(e), providerFactory);
                propertyInjector.inject(e);
                providerFactory.registerProviderInstance(e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            Set pcs = providerFactory.getProviderClasses();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\ndefault-providers:\n");
            for (Object provider : pcs) {
                stringBuilder.append("  ").append(provider).append("\n");
            }
            LOGGER.debug(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.started) {
            return;
        }
        RestServer restServer = this;
        synchronized (restServer) {
            if (this.started) {
                return;
            }
            try {
                this.httpServer.start();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Start the http rest server at port {}", this.serverConfig.getPort());
                }
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000028", "rest", this.serverConfig.getPort()), e);
            }
            this.started = true;
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasNoEntry() {
        return false;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stop the http rest server at port {}", this.serverConfig.getPort());
            }
            this.httpServer.stop();
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("010000030", this.serverConfig.getPort()), e);
        }
        this.started = false;
    }

    @Override
    public void registerProcessor(ProviderConfig providerConfig, Invoker instance) {
        if (!this.isStarted()) {
            this.start();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Register jaxrs service to base url http://" + this.serverConfig.getHost() + ":" + this.serverConfig.getPort() + this.serverConfig.getContextPath());
        }
        Object obj = null;
        try {
            obj = ProxyFactory.buildProxy(providerConfig.getProxy(), providerConfig.getProxyClass(), instance);
            this.httpServer.getDeployment().getRegistry().addResourceFactory((ResourceFactory)new SofaResourceFactory(providerConfig, obj), this.serverConfig.getContextPath());
            this.invokerCnt.incrementAndGet();
        }
        catch (SofaRpcRuntimeException e) {
            LOGGER.error(LogCodes.getLog("010000016", "restServer"), e);
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010000016", "restServer"), e);
        }
    }

    @Override
    public void unRegisterProcessor(ProviderConfig providerConfig, boolean closeIfNoEntry) {
        if (!this.isStarted()) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Unregister jaxrs service to port {} and base path is {}", this.serverConfig.getPort(), this.serverConfig.getContextPath());
        }
        try {
            this.httpServer.getDeployment().getRegistry().removeRegistrations(providerConfig.getRef().getClass(), this.serverConfig.getContextPath());
            this.invokerCnt.decrementAndGet();
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("010000031", "jaxrs"), e);
        }
        if (closeIfNoEntry && this.invokerCnt.get() == 0) {
            this.stop();
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.httpServer = null;
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (hook != null) {
            hook.preDestroy();
        }
        this.destroy();
        if (hook != null) {
            hook.postDestroy();
        }
    }
}

