/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.doc.swagger.generate;

import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.doc.swagger.generate.Reader;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.util.HashMap;
import java.util.List;

public class GenerateService {
    private String defaultProtocol = "bolt";
    private String basePath = "/rest/";

    public GenerateService() {
    }

    public GenerateService(String defaultProtocol, String basePath) {
        this.defaultProtocol = defaultProtocol;
        this.basePath = basePath;
    }

    public String generate() {
        return this.generate(this.defaultProtocol);
    }

    public String generate(String protocol) {
        if (protocol == null) {
            protocol = this.defaultProtocol;
        }
        Swagger swagger = new Swagger();
        swagger.setInfo(this.getInfo());
        swagger.setBasePath(this.basePath);
        HashMap interfaceMapRef = new HashMap();
        List<ProviderBootstrap> providerBootstraps = RpcRuntimeContext.getProviderConfigs();
        block2: for (ProviderBootstrap providerBootstrap : providerBootstraps) {
            ProviderConfig providerConfig = providerBootstrap.getProviderConfig();
            List<ServerConfig> server = providerConfig.getServer();
            for (ServerConfig serverConfig : server) {
                if (!serverConfig.getProtocol().equals(protocol)) continue;
                interfaceMapRef.put(providerConfig.getProxyClass(), providerConfig.getRef());
                continue block2;
            }
        }
        Reader.read(swagger, interfaceMapRef, "");
        String result = null;
        try {
            result = Json.mapper().writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Info getInfo() {
        Info info = new Info();
        info.setVersion("");
        info.setTitle("Swagger API");
        return info;
    }
}

