/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.snappy;

import com.alipay.sofa.rpc.codec.Compressor;
import com.alipay.sofa.rpc.codec.snappy.CorruptionException;
import com.alipay.sofa.rpc.codec.snappy.SnappyCompressor;
import com.alipay.sofa.rpc.codec.snappy.SnappyDecompressor;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.Arrays;

@Extension(value="snappy", code=2)
public final class SnappyRpcCompressor
implements Compressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnappyRpcCompressor.class);
    static final int LITERAL = 0;
    static final int COPY_1_BYTE_OFFSET = 1;
    static final int COPY_2_BYTE_OFFSET = 2;
    static final int COPY_4_BYTE_OFFSET = 3;

    public SnappyRpcCompressor() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Init Snappy compressor");
        }
    }

    @Override
    public byte[] deCompress(byte[] src) {
        return this.uncompress(src, 0, src.length);
    }

    public int getUncompressedLength(byte[] compressed, int compressedOffset) throws CorruptionException {
        return SnappyDecompressor.getUncompressedLength(compressed, compressedOffset);
    }

    public byte[] uncompress(byte[] compressed, int compressedOffset, int compressedSize) throws CorruptionException {
        return SnappyDecompressor.uncompress(compressed, compressedOffset, compressedSize);
    }

    public int uncompress(byte[] compressed, int compressedOffset, int compressedSize, byte[] uncompressed, int uncompressedOffset) throws CorruptionException {
        return SnappyDecompressor.uncompress(compressed, compressedOffset, compressedSize, uncompressed, uncompressedOffset);
    }

    public int maxCompressedLength(int sourceLength) {
        return SnappyCompressor.maxCompressedLength(sourceLength);
    }

    public int compress(byte[] uncompressed, int uncompressedOffset, int uncompressedLength, byte[] compressed, int compressedOffset) {
        return SnappyCompressor.compress(uncompressed, uncompressedOffset, uncompressedLength, compressed, compressedOffset);
    }

    @Override
    public byte[] compress(byte[] data) {
        byte[] compressedOut = new byte[this.maxCompressedLength(data.length)];
        int compressedSize = this.compress(data, 0, data.length, compressedOut, 0);
        byte[] trimmedBuffer = Arrays.copyOf(compressedOut, compressedSize);
        return trimmedBuffer;
    }
}

