/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.LoadBalancer;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.LogCodes;

public class LoadBalancerFactory {
    public static LoadBalancer getLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        return LoadBalancerFactory.getLoadBalancer(consumerBootstrap, consumerBootstrap.getConsumerConfig().getLoadBalancer());
    }

    public static LoadBalancer getLoadBalancer(ConsumerBootstrap consumerBootstrap, String loadBalancer) {
        try {
            ExtensionClass<LoadBalancer> ext = ExtensionLoaderFactory.getExtensionLoader(LoadBalancer.class).getExtensionClass(loadBalancer);
            if (ext == null) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("020030001", loadBalancer));
            }
            return ext.getExtInstance(new Class[]{ConsumerBootstrap.class}, new Object[]{consumerBootstrap});
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020030001", loadBalancer), e);
        }
    }
}

