/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.factory.LimitAPIFactory;
import java.io.InputStream;
import org.slf4j.Logger;

public class APIFactory {
    private static final Logger LOG = LoggerFactory.getLogger(APIFactory.class);

    public static Configuration defaultConfig() throws PolarisException {
        return ConfigAPIFactory.defaultConfig();
    }

    public static Configuration loadConfig(InputStream configStream) throws PolarisException {
        return ConfigAPIFactory.loadConfig(configStream);
    }

    public static SDKContext initContext() throws PolarisException {
        return SDKContext.initContext();
    }

    public static SDKContext initContextByConfig(Configuration config) throws PolarisException {
        return SDKContext.initContextByConfig(config);
    }

    public static SDKContext initContextByFile(InputStream inputStream2) throws PolarisException {
        Configuration config = ConfigAPIFactory.loadConfig(inputStream2);
        return SDKContext.initContextByConfig(config);
    }

    public static ConsumerAPI createConsumerAPI() throws PolarisException {
        return DiscoveryAPIFactory.createConsumerAPI();
    }

    public static ConsumerAPI createConsumerAPIByContext(SDKContext context) throws PolarisException {
        return DiscoveryAPIFactory.createConsumerAPIByContext(context);
    }

    public static ConsumerAPI createConsumerAPIByFile(InputStream inputStream2) throws PolarisException {
        SDKContext context = APIFactory.initContextByFile(inputStream2);
        return APIFactory.createConsumerAPIByContext(context);
    }

    public static ConsumerAPI createConsumerAPIByConfig(Configuration config) throws PolarisException {
        return DiscoveryAPIFactory.createConsumerAPIByConfig(config);
    }

    public static ProviderAPI createProviderAPI() throws PolarisException {
        return DiscoveryAPIFactory.createProviderAPI();
    }

    public static ProviderAPI createProviderAPIByContext(SDKContext context) throws PolarisException {
        return DiscoveryAPIFactory.createProviderAPIByContext(context);
    }

    public static ProviderAPI createProviderAPIByConfig(Configuration config) throws PolarisException {
        return DiscoveryAPIFactory.createProviderAPIByConfig(config);
    }

    public static ProviderAPI createProviderAPIByFile(InputStream inputStream2) throws PolarisException {
        SDKContext context = APIFactory.initContextByFile(inputStream2);
        return APIFactory.createProviderAPIByContext(context);
    }

    public static LimitAPI createLimitAPI() throws PolarisException {
        return LimitAPIFactory.createLimitAPI();
    }

    public static LimitAPI createLimitAPIByContext(SDKContext context) throws PolarisException {
        return LimitAPIFactory.createLimitAPIByContext(context);
    }

    public static LimitAPI createLimitAPIByConfig(Configuration config) throws PolarisException {
        return LimitAPIFactory.createLimitAPIByConfig(config);
    }

    public static ConfigFileService createConfigFileService() throws PolarisException {
        return ConfigFileServiceFactory.createConfigFileService();
    }

    public static ConfigFileService createConfigFileService(SDKContext context) throws PolarisException {
        return ConfigFileServiceFactory.createConfigFileService(context);
    }

    public static ConfigFileService createConfigFileService(Configuration config) throws PolarisException {
        return ConfigFileServiceFactory.createConfigFileService(config);
    }
}

