/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.rpc;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceInstancesWrap;
import com.tencent.polaris.api.rpc.BaseEntity;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class InstancesResponse
extends BaseEntity {
    private final ServiceInstances serviceInstances;
    private final Map<String, String> metadata;
    private final int totalWeight;
    private final String subset;
    private final Map<String, ModelProto.MatchString> subsetMetadata;
    private final Instance[] instances;

    public InstancesResponse(ServiceInstances serviceInstances, String subset, Map<String, ModelProto.MatchString> subsetMetadata) {
        this.serviceInstances = serviceInstances;
        this.metadata = serviceInstances.getMetadata();
        this.setService(serviceInstances.getService());
        this.setNamespace(serviceInstances.getNamespace());
        List<Instance> svcInstances = serviceInstances.getInstances();
        this.instances = svcInstances.toArray(new Instance[svcInstances.size()]);
        this.totalWeight = serviceInstances.getTotalWeight();
        this.subset = subset;
        this.subsetMetadata = subsetMetadata;
    }

    public InstancesResponse(ServiceInstances serviceInstances, Instance singleInstance, String subset, Map<String, ModelProto.MatchString> subsetMetadata) {
        this.serviceInstances = serviceInstances;
        this.metadata = serviceInstances.getMetadata();
        this.setService(serviceInstances.getService());
        this.setNamespace(serviceInstances.getNamespace());
        this.instances = new Instance[]{singleInstance};
        this.totalWeight = serviceInstances.getTotalWeight();
        this.subset = subset;
        this.subsetMetadata = subsetMetadata;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Instance[] getInstances() {
        return this.instances;
    }

    public Instance getInstance() {
        if (null != this.instances && this.instances.length > 0) {
            return this.instances[0];
        }
        return null;
    }

    public ServiceInstances toServiceInstances() {
        return new ServiceInstancesWrap(this.serviceInstances, Arrays.asList(this.getInstances()), this.totalWeight);
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public ServiceInstances getServiceInstances() {
        return this.serviceInstances;
    }

    public boolean isServiceExist() {
        return StringUtils.isNotBlank(this.serviceInstances.getRevision());
    }

    public String getSubset() {
        return this.subset;
    }

    @Override
    public String toString() {
        return "InstancesResponse{serviceInstances=" + this.serviceInstances + ", metadata=" + this.metadata + ", totalWeight=" + this.totalWeight + ", subset='" + this.subset + '\'' + ", instances=" + Arrays.toString(this.instances) + "} " + super.toString();
    }
}

