/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Influence;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class AnomalyCause
implements JsonpSerializable {
    private final List<Double> actual;
    private final String byFieldName;
    private final String byFieldValue;
    private final String correlatedByFieldValue;
    private final String fieldName;
    private final String function;
    private final String functionDescription;
    private final List<Influence> influencers;
    private final String overFieldName;
    private final String overFieldValue;
    private final String partitionFieldName;
    private final String partitionFieldValue;
    private final double probability;
    private final List<Double> typical;
    public static final JsonpDeserializer<AnomalyCause> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnomalyCause::setupAnomalyCauseDeserializer);

    private AnomalyCause(Builder builder) {
        this.actual = ApiTypeHelper.unmodifiableRequired(builder.actual, (Object)this, "actual");
        this.byFieldName = ApiTypeHelper.requireNonNull(builder.byFieldName, this, "byFieldName");
        this.byFieldValue = ApiTypeHelper.requireNonNull(builder.byFieldValue, this, "byFieldValue");
        this.correlatedByFieldValue = ApiTypeHelper.requireNonNull(builder.correlatedByFieldValue, this, "correlatedByFieldValue");
        this.fieldName = ApiTypeHelper.requireNonNull(builder.fieldName, this, "fieldName");
        this.function = ApiTypeHelper.requireNonNull(builder.function, this, "function");
        this.functionDescription = ApiTypeHelper.requireNonNull(builder.functionDescription, this, "functionDescription");
        this.influencers = ApiTypeHelper.unmodifiableRequired(builder.influencers, (Object)this, "influencers");
        this.overFieldName = ApiTypeHelper.requireNonNull(builder.overFieldName, this, "overFieldName");
        this.overFieldValue = ApiTypeHelper.requireNonNull(builder.overFieldValue, this, "overFieldValue");
        this.partitionFieldName = ApiTypeHelper.requireNonNull(builder.partitionFieldName, this, "partitionFieldName");
        this.partitionFieldValue = ApiTypeHelper.requireNonNull(builder.partitionFieldValue, this, "partitionFieldValue");
        this.probability = ApiTypeHelper.requireNonNull(builder.probability, this, "probability");
        this.typical = ApiTypeHelper.unmodifiableRequired(builder.typical, (Object)this, "typical");
    }

    public static AnomalyCause of(Function<Builder, ObjectBuilder<AnomalyCause>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Double> actual() {
        return this.actual;
    }

    public final String byFieldName() {
        return this.byFieldName;
    }

    public final String byFieldValue() {
        return this.byFieldValue;
    }

    public final String correlatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String function() {
        return this.function;
    }

    public final String functionDescription() {
        return this.functionDescription;
    }

    public final List<Influence> influencers() {
        return this.influencers;
    }

    public final String overFieldName() {
        return this.overFieldName;
    }

    public final String overFieldValue() {
        return this.overFieldValue;
    }

    public final String partitionFieldName() {
        return this.partitionFieldName;
    }

    public final String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public final double probability() {
        return this.probability;
    }

    public final List<Double> typical() {
        return this.typical;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actual)) {
            generator.writeKey("actual");
            generator.writeStartArray();
            for (Double d : this.actual) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("by_field_name");
        generator.write(this.byFieldName);
        generator.writeKey("by_field_value");
        generator.write(this.byFieldValue);
        generator.writeKey("correlated_by_field_value");
        generator.write(this.correlatedByFieldValue);
        generator.writeKey("field_name");
        generator.write(this.fieldName);
        generator.writeKey("function");
        generator.write(this.function);
        generator.writeKey("function_description");
        generator.write(this.functionDescription);
        if (ApiTypeHelper.isDefined(this.influencers)) {
            generator.writeKey("influencers");
            generator.writeStartArray();
            for (Influence influence : this.influencers) {
                influence.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("over_field_name");
        generator.write(this.overFieldName);
        generator.writeKey("over_field_value");
        generator.write(this.overFieldValue);
        generator.writeKey("partition_field_name");
        generator.write(this.partitionFieldName);
        generator.writeKey("partition_field_value");
        generator.write(this.partitionFieldValue);
        generator.writeKey("probability");
        generator.write(this.probability);
        if (ApiTypeHelper.isDefined(this.typical)) {
            generator.writeKey("typical");
            generator.writeStartArray();
            for (Double d : this.typical) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAnomalyCauseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actual, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "actual");
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name");
        op.add(Builder::byFieldValue, JsonpDeserializer.stringDeserializer(), "by_field_value");
        op.add(Builder::correlatedByFieldValue, JsonpDeserializer.stringDeserializer(), "correlated_by_field_value");
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name");
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function");
        op.add(Builder::functionDescription, JsonpDeserializer.stringDeserializer(), "function_description");
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(Influence._DESERIALIZER), "influencers");
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name");
        op.add(Builder::overFieldValue, JsonpDeserializer.stringDeserializer(), "over_field_value");
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name");
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value");
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability");
        op.add(Builder::typical, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "typical");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnomalyCause> {
        private List<Double> actual;
        private String byFieldName;
        private String byFieldValue;
        private String correlatedByFieldValue;
        private String fieldName;
        private String function;
        private String functionDescription;
        private List<Influence> influencers;
        private String overFieldName;
        private String overFieldValue;
        private String partitionFieldName;
        private String partitionFieldValue;
        private Double probability;
        private List<Double> typical;

        public final Builder actual(List<Double> list) {
            this.actual = Builder._listAddAll(this.actual, list);
            return this;
        }

        public final Builder actual(Double value, Double ... values) {
            this.actual = Builder._listAdd(this.actual, value, values);
            return this;
        }

        public final Builder byFieldName(String value) {
            this.byFieldName = value;
            return this;
        }

        public final Builder byFieldValue(String value) {
            this.byFieldValue = value;
            return this;
        }

        public final Builder correlatedByFieldValue(String value) {
            this.correlatedByFieldValue = value;
            return this;
        }

        public final Builder fieldName(String value) {
            this.fieldName = value;
            return this;
        }

        public final Builder function(String value) {
            this.function = value;
            return this;
        }

        public final Builder functionDescription(String value) {
            this.functionDescription = value;
            return this;
        }

        public final Builder influencers(List<Influence> list) {
            this.influencers = Builder._listAddAll(this.influencers, list);
            return this;
        }

        public final Builder influencers(Influence value, Influence ... values) {
            this.influencers = Builder._listAdd(this.influencers, value, values);
            return this;
        }

        public final Builder influencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.influencers(fn.apply(new Influence.Builder()).build(), new Influence[0]);
        }

        public final Builder overFieldName(String value) {
            this.overFieldName = value;
            return this;
        }

        public final Builder overFieldValue(String value) {
            this.overFieldValue = value;
            return this;
        }

        public final Builder partitionFieldName(String value) {
            this.partitionFieldName = value;
            return this;
        }

        public final Builder partitionFieldValue(String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public final Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public final Builder typical(List<Double> list) {
            this.typical = Builder._listAddAll(this.typical, list);
            return this;
        }

        public final Builder typical(Double value, Double ... values) {
            this.typical = Builder._listAdd(this.typical, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnomalyCause build() {
            this._checkSingleUse();
            return new AnomalyCause(this);
        }
    }
}

