/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ForceMergeConfiguration
implements JsonpSerializable {
    private final int maxNumSegments;
    public static final JsonpDeserializer<ForceMergeConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForceMergeConfiguration::setupForceMergeConfigurationDeserializer);

    private ForceMergeConfiguration(Builder builder) {
        this.maxNumSegments = ApiTypeHelper.requireNonNull(builder.maxNumSegments, this, "maxNumSegments");
    }

    public static ForceMergeConfiguration of(Function<Builder, ObjectBuilder<ForceMergeConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int maxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_num_segments");
        generator.write(this.maxNumSegments);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupForceMergeConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxNumSegments, JsonpDeserializer.integerDeserializer(), "max_num_segments");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ForceMergeConfiguration> {
        private Integer maxNumSegments;

        public final Builder maxNumSegments(int value) {
            this.maxNumSegments = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForceMergeConfiguration build() {
            this._checkSingleUse();
            return new ForceMergeConfiguration(this);
        }
    }
}

