/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PathHierarchyTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final Integer bufferSize;
    @Nullable
    private final String delimiter;
    @Nullable
    private final String replacement;
    @Nullable
    private final Boolean reverse;
    @Nullable
    private final Integer skip;
    public static final JsonpDeserializer<PathHierarchyTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PathHierarchyTokenizer::setupPathHierarchyTokenizerDeserializer);

    private PathHierarchyTokenizer(Builder builder) {
        super(builder);
        this.bufferSize = builder.bufferSize;
        this.delimiter = builder.delimiter;
        this.replacement = builder.replacement;
        this.reverse = builder.reverse;
        this.skip = builder.skip;
    }

    public static PathHierarchyTokenizer of(Function<Builder, ObjectBuilder<PathHierarchyTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.PathHierarchy;
    }

    @Nullable
    public final Integer bufferSize() {
        return this.bufferSize;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final String replacement() {
        return this.replacement;
    }

    @Nullable
    public final Boolean reverse() {
        return this.reverse;
    }

    @Nullable
    public final Integer skip() {
        return this.skip;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "path_hierarchy");
        super.serializeInternal(generator, mapper);
        if (this.bufferSize != null) {
            generator.writeKey("buffer_size");
            generator.write(this.bufferSize.intValue());
        }
        if (this.delimiter != null) {
            generator.writeKey("delimiter");
            generator.write(this.delimiter);
        }
        if (this.replacement != null) {
            generator.writeKey("replacement");
            generator.write(this.replacement);
        }
        if (this.reverse != null) {
            generator.writeKey("reverse");
            generator.write(this.reverse.booleanValue());
        }
        if (this.skip != null) {
            generator.writeKey("skip");
            generator.write(this.skip.intValue());
        }
    }

    protected static void setupPathHierarchyTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::bufferSize, JsonpDeserializer.integerDeserializer(), "buffer_size");
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.add(Builder::reverse, JsonpDeserializer.booleanDeserializer(), "reverse");
        op.add(Builder::skip, JsonpDeserializer.integerDeserializer(), "skip");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PathHierarchyTokenizer> {
        @Nullable
        private Integer bufferSize;
        @Nullable
        private String delimiter;
        @Nullable
        private String replacement;
        @Nullable
        private Boolean reverse;
        @Nullable
        private Integer skip;

        public final Builder bufferSize(@Nullable Integer value) {
            this.bufferSize = value;
            return this;
        }

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder replacement(@Nullable String value) {
            this.replacement = value;
            return this;
        }

        public final Builder reverse(@Nullable Boolean value) {
            this.reverse = value;
            return this;
        }

        public final Builder skip(@Nullable Integer value) {
            this.skip = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PathHierarchyTokenizer build() {
            this._checkSingleUse();
            return new PathHierarchyTokenizer(this);
        }
    }
}

