/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.async;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.transport.async.MotanAsync;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class MotanAsyncProcessor
extends AbstractProcessor {
    protected static String ASYNC = "Async";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(MotanAsync.class.getName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MotanAsync.class)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "MotanAsyncProcessor will process " + element);
            try {
                this.writeAsyncClass(element);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "MotanAsyncProcessor done for " + element);
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "MotanAsyncProcessor process " + element + " fail. exception:" + e.getMessage());
                e.printStackTrace();
            }
        }
        return true;
    }

    private void writeAsyncClass(Element elem) throws Exception {
        if (elem.getKind().isInterface()) {
            TypeElement interfaceClazz = (TypeElement)elem;
            String className = interfaceClazz.getSimpleName().toString();
            TypeSpec.Builder classBuilder = TypeSpec.interfaceBuilder((String)(className + ASYNC)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(TypeName.get((TypeMirror)elem.asType()));
            classBuilder.addTypeVariables(this.getTypeNames(interfaceClazz.getTypeParameters()));
            this.addMethods(interfaceClazz, classBuilder);
            this.addSuperInterfaceMethods(interfaceClazz.getInterfaces(), classBuilder);
            JavaFile javaFile = JavaFile.builder((String)this.processingEnv.getElementUtils().getPackageOf(interfaceClazz).getQualifiedName().toString(), (TypeSpec)classBuilder.build()).build();
            javaFile.writeTo(this.processingEnv.getFiler());
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "MotanAsyncProcessor not process, because " + elem + " not a interface.");
        }
    }

    private void addMethods(TypeElement interfaceClazz, TypeSpec.Builder classBuilder) {
        List<? extends Element> elements = interfaceClazz.getEnclosedElements();
        if (elements != null && !elements.isEmpty()) {
            for (Element element : elements) {
                if (!ElementKind.METHOD.equals((Object)element.getKind())) continue;
                ExecutableElement method = (ExecutableElement)element;
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)(method.getSimpleName().toString() + ASYNC)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(ResponseFuture.class).addTypeVariables(this.getTypeNames(method.getTypeParameters()));
                List<? extends VariableElement> vars = method.getParameters();
                for (VariableElement variableElement : vars) {
                    methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)variableElement.asType()), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]).build());
                }
                classBuilder.addMethod(methodBuilder.build());
            }
        }
    }

    private List<TypeVariableName> getTypeNames(List<? extends TypeParameterElement> types) {
        ArrayList<TypeVariableName> result = new ArrayList<TypeVariableName>();
        if (types != null && !types.isEmpty()) {
            for (TypeParameterElement typeParameterElement : types) {
                result.add(TypeVariableName.get((TypeParameterElement)typeParameterElement));
            }
        }
        return result;
    }

    private void addSuperInterfaceMethods(List<? extends TypeMirror> superInterfaces, TypeSpec.Builder classBuilder) {
        if (superInterfaces != null && !superInterfaces.isEmpty()) {
            for (TypeMirror typeMirror : superInterfaces) {
                try {
                    if (!typeMirror.getKind().equals((Object)TypeKind.DECLARED)) continue;
                    TypeElement de = (TypeElement)((DeclaredType)typeMirror).asElement();
                    this.addMethods(de, classBuilder);
                    this.addSuperInterfaceMethods(de.getInterfaces(), classBuilder);
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "MotanAsyncProcessor process superinterface " + typeMirror.toString() + " fail. exception:" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

