/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.serialize;

import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import java.io.IOException;

@SpiMeta(name="breeze")
public class BreezeSerialization
implements Serialization {
    public static int DEFAULT_BUFFER_SIZE = 1024;

    @Override
    public byte[] serialize(Object o) throws IOException {
        BreezeBuffer buffer = new BreezeBuffer(DEFAULT_BUFFER_SIZE);
        BreezeWriter.writeObject((BreezeBuffer)buffer, (Object)o);
        buffer.flip();
        return buffer.getBytes();
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clz) throws IOException {
        BreezeBuffer buffer = new BreezeBuffer(bytes);
        return (T)BreezeReader.readObject((BreezeBuffer)buffer, clz);
    }

    @Override
    public byte[] serializeMulti(Object[] objects) throws IOException {
        BreezeBuffer buffer = new BreezeBuffer(DEFAULT_BUFFER_SIZE);
        for (Object o : objects) {
            BreezeWriter.writeObject((BreezeBuffer)buffer, (Object)o);
        }
        buffer.flip();
        return buffer.getBytes();
    }

    @Override
    public Object[] deserializeMulti(byte[] bytes, Class<?>[] classes) throws IOException {
        Object[] objects = new Object[classes.length];
        BreezeBuffer buffer = new BreezeBuffer(bytes);
        for (int i = 0; i < classes.length; ++i) {
            objects[i] = BreezeReader.readObject((BreezeBuffer)buffer, classes[i]);
        }
        return objects;
    }

    @Override
    public int getSerializationNumber() {
        return 8;
    }
}

