/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.LogSpace;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4CommonsLoggingBuilder;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4Log4j2Builder;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4Log4jBuilder;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4LogbackBuilder;
import com.alipay.sofa.common.log.proxy.TemporaryILoggerFactoryPool;
import com.alipay.sofa.common.utils.ClassLoaderUtil;
import com.alipay.sofa.common.utils.ReportUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class MultiAppLoggerSpaceManager {
    private static final AbstractLoggerSpaceFactory NOP_LOGGER_FACTORY = new AbstractLoggerSpaceFactory("nop"){

        public Logger getLogger(String name) {
            return Constants.DEFAULT_LOG;
        }
    };
    private static final Map<com.alipay.sofa.common.space.SpaceId, LogSpace> LOG_FACTORY_MAP = new ConcurrentHashMap<com.alipay.sofa.common.space.SpaceId, LogSpace>();

    public static void init(String spaceName, Map<String, String> props) {
        MultiAppLoggerSpaceManager.init(new com.alipay.sofa.common.space.SpaceId(spaceName), props, ClassLoaderUtil.getCallerClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(com.alipay.sofa.common.space.SpaceId spaceId, Map<String, String> props, ClassLoader spaceClassloader) {
        if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            ReportUtil.reportWarn("Logger space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
            return;
        }
        com.alipay.sofa.common.space.SpaceId spaceId2 = spaceId;
        synchronized (spaceId2) {
            if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
                ReportUtil.reportWarn("Logger space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
                return;
            }
            MultiAppLoggerSpaceManager.doInit(spaceId, props, spaceClassloader);
        }
        ReportUtil.reportInfo("Logger Space: \"" + spaceId.toString() + "\" init ok.");
    }

    @Deprecated
    public static void init(SpaceId spaceId, Map<String, String> props, ClassLoader spaceClassloader) {
        MultiAppLoggerSpaceManager.init((com.alipay.sofa.common.space.SpaceId)spaceId, props, spaceClassloader);
    }

    static void doInit(String spaceName, Map<String, String> props, ClassLoader spaceClassloader) {
        MultiAppLoggerSpaceManager.doInit(com.alipay.sofa.common.space.SpaceId.withSpaceName(spaceName), props, spaceClassloader);
    }

    static void doInit(com.alipay.sofa.common.space.SpaceId spaceId, Map<String, String> props, ClassLoader spaceClassloader) {
        LogSpace logSpace = new LogSpace(props, spaceClassloader);
        LOG_FACTORY_MAP.putIfAbsent(spaceId, logSpace);
    }

    public static Logger getLoggerBySpace(String name, String spaceName) {
        ClassLoader callerClassLoader = ClassLoaderUtil.getCallerClassLoader();
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, new com.alipay.sofa.common.space.SpaceId(spaceName), callerClassLoader);
    }

    public static Logger getLoggerBySpace(String name, com.alipay.sofa.common.space.SpaceId spaceId) {
        ClassLoader callerClassLoader = ClassLoaderUtil.getCallerClassLoader();
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId, callerClassLoader);
    }

    @Deprecated
    public static Logger getLoggerBySpace(String name, SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, (com.alipay.sofa.common.space.SpaceId)spaceId);
    }

    public static Logger getLoggerBySpace(String name, String spaceName, ClassLoader spaceClassloader) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, new com.alipay.sofa.common.space.SpaceId(spaceName), spaceClassloader);
    }

    public static Logger getLoggerBySpace(String name, com.alipay.sofa.common.space.SpaceId spaceId, ClassLoader spaceClassloader) {
        AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = MultiAppLoggerSpaceManager.getILoggerFactoryBySpaceName(spaceId, spaceClassloader);
        return abstractLoggerSpaceFactory.getLogger(name);
    }

    @Deprecated
    public static Logger getLoggerBySpace(String name, SpaceId spaceId, ClassLoader spaceClassloader) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, (com.alipay.sofa.common.space.SpaceId)spaceId, spaceClassloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractLoggerSpaceFactory getILoggerFactoryBySpaceName(com.alipay.sofa.common.space.SpaceId spaceId, ClassLoader spaceClassloader) {
        if (!MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            return TemporaryILoggerFactoryPool.get(spaceId, spaceClassloader);
        }
        AbstractLoggerSpaceFactory factory = NOP_LOGGER_FACTORY;
        LogSpace space = LOG_FACTORY_MAP.get(spaceId);
        if (!MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
            LogSpace logSpace = space;
            synchronized (logSpace) {
                if (!MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
                    factory = MultiAppLoggerSpaceManager.createILoggerFactory(spaceId, space, spaceClassloader);
                    space.setAbstractLoggerSpaceFactory(factory);
                } else {
                    factory = LOG_FACTORY_MAP.get(spaceId).getAbstractLoggerSpaceFactory();
                }
            }
        } else {
            factory = LOG_FACTORY_MAP.get(spaceId).getAbstractLoggerSpaceFactory();
        }
        return factory;
    }

    public static Logger setLoggerLevel(String loggerName, String spaceName, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, new com.alipay.sofa.common.space.SpaceId(spaceName), adapterLevel);
    }

    public static Logger setLoggerLevel(String loggerName, com.alipay.sofa.common.space.SpaceId spaceId, AdapterLevel adapterLevel) {
        ClassLoader callerClassLoader = ClassLoaderUtil.getCallerClassLoader();
        AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = MultiAppLoggerSpaceManager.getILoggerFactoryBySpaceName(spaceId, callerClassLoader);
        try {
            abstractLoggerSpaceFactory.setLevel(loggerName, adapterLevel);
        }
        catch (Exception e) {
            ReportUtil.reportError("SetLoggerLevel Error : ", e);
        }
        return abstractLoggerSpaceFactory.getLogger(loggerName);
    }

    @Deprecated
    public static Logger setLoggerLevel(String loggerName, SpaceId spaceId, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, (com.alipay.sofa.common.space.SpaceId)spaceId, adapterLevel);
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceName(String spaceName) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(new com.alipay.sofa.common.space.SpaceId(spaceName));
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceId(com.alipay.sofa.common.space.SpaceId spaceId) {
        if (spaceId == null) {
            return null;
        }
        LogSpace logSpace = LOG_FACTORY_MAP.get(spaceId);
        if (logSpace == null) {
            return null;
        }
        AbstractLoggerSpaceFactory oldFactory = logSpace.getAbstractLoggerSpaceFactory();
        LOG_FACTORY_MAP.remove(spaceId);
        ReportUtil.reportWarn("Log Space Name[" + spaceId.getSpaceName() + "] is Removed from Current Log Space Manager!");
        return oldFactory;
    }

    @Deprecated
    public static ILoggerFactory removeILoggerFactoryBySpaceId(SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId((com.alipay.sofa.common.space.SpaceId)spaceId);
    }

    public static boolean isSpaceInitialized(String spaceName) {
        return MultiAppLoggerSpaceManager.isSpaceInitialized(new com.alipay.sofa.common.space.SpaceId(spaceName));
    }

    public static boolean isSpaceInitialized(com.alipay.sofa.common.space.SpaceId spaceId) {
        return LOG_FACTORY_MAP.containsKey(spaceId);
    }

    @Deprecated
    public static boolean isSpaceInitialized(SpaceId spaceId) {
        return LOG_FACTORY_MAP.containsKey(spaceId);
    }

    private static boolean isSpaceILoggerFactoryExisted(com.alipay.sofa.common.space.SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId) && LOG_FACTORY_MAP.get(spaceId).getAbstractLoggerSpaceFactory() != null;
    }

    @Deprecated
    public static Map getSpacesMap() {
        return Collections.emptyMap();
    }

    private static AbstractLoggerSpaceFactory createILoggerFactory(com.alipay.sofa.common.space.SpaceId spaceId, LogSpace logSpace, ClassLoader spaceClassloader) {
        if (Constants.SOFA_MIDDLEWARE_LOG_DISABLE) {
            ReportUtil.reportWarn("Sofa-Middleware-Log is disabled!  -Dsofa.middleware.log.disable=true");
            return NOP_LOGGER_FACTORY;
        }
        logSpace.putAll(LogEnvUtils.processGlobalSystemLogProperties());
        try {
            if (Constants.LOGBACK_MIDDLEWARE_LOG_DISABLE) {
                ReportUtil.reportWarn("Logback-Sofa-Middleware-Log is disabled! -Dlogback.middleware.log.disable=true");
            } else if (LogEnvUtils.isLogbackUsable(spaceClassloader)) {
                ReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Logback ]");
                LoggerSpaceFactory4LogbackBuilder loggerSpaceFactory4LogbackBuilder = new LoggerSpaceFactory4LogbackBuilder(spaceId, logSpace);
                return loggerSpaceFactory4LogbackBuilder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            if (Constants.LOG4J2_MIDDLEWARE_LOG_DISABLE) {
                ReportUtil.reportWarn("Log4j2-Sofa-Middleware-Log is disabled!  -Dlog4j2.middleware.log.disable=true");
            } else if (LogEnvUtils.isLog4j2Usable(spaceClassloader)) {
                ReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Log4j2 ]");
                LoggerSpaceFactory4Log4j2Builder loggerSpaceFactory4Log4j2Builder = new LoggerSpaceFactory4Log4j2Builder(spaceId, logSpace);
                return loggerSpaceFactory4Log4j2Builder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            if (Constants.LOG4J_MIDDLEWARE_LOG_DISABLE) {
                ReportUtil.reportWarn("Log4j-Sofa-Middleware-Log is disabled!  -Dlog4j.middleware.log.disable=true");
            } else if (LogEnvUtils.isLog4jUsable(spaceClassloader)) {
                ReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Log4j ]");
                LoggerSpaceFactory4Log4jBuilder loggerSpaceFactory4Log4jBuilder = new LoggerSpaceFactory4Log4jBuilder(spaceId, logSpace);
                return loggerSpaceFactory4Log4jBuilder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            if (Constants.LOG4J_COMMONS_LOGGING_MIDDLEWARE_LOG_DISABLE) {
                ReportUtil.reportWarn("Log4j-Sofa-Middleware-Log(commons-logging) is disabled!  -Dlog4j.commons.logging.middleware.log.disable=true");
            } else if (LogEnvUtils.isCommonsLoggingUsable(spaceClassloader)) {
                ReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Log4j (Adapter commons-logging to slf4j)]");
                LoggerSpaceFactory4CommonsLoggingBuilder loggerSpaceFactory4Log4jBuilder = new LoggerSpaceFactory4CommonsLoggingBuilder(spaceId, logSpace);
                return loggerSpaceFactory4Log4jBuilder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            ReportUtil.reportWarn("[" + spaceId.toString() + "] No log util is usable, Default app logger will be used.");
        }
        catch (Throwable e) {
            ReportUtil.reportError("[" + spaceId.toString() + "] Build ILoggerFactory error! Default app logger will be used.", e);
        }
        return NOP_LOGGER_FACTORY;
    }

    public static Map<com.alipay.sofa.common.space.SpaceId, LogSpace> getLogFactoryMap() {
        return new HashMap<com.alipay.sofa.common.space.SpaceId, LogSpace>(LOG_FACTORY_MAP);
    }
}

