/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AppAuthDataRefresh;
import org.apache.shenyu.sync.data.http.refresh.DataRefresh;
import org.apache.shenyu.sync.data.http.refresh.DiscoveryUpstreamDataRefresh;
import org.apache.shenyu.sync.data.http.refresh.MetaDataRefresh;
import org.apache.shenyu.sync.data.http.refresh.PluginDataRefresh;
import org.apache.shenyu.sync.data.http.refresh.ProxySelectorRefresh;
import org.apache.shenyu.sync.data.http.refresh.RuleDataRefresh;
import org.apache.shenyu.sync.data.http.refresh.SelectorDataRefresh;

public final class DataRefreshFactory {
    private static final EnumMap<ConfigGroupEnum, DataRefresh> ENUM_MAP = new EnumMap(ConfigGroupEnum.class);

    public DataRefreshFactory(PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        ENUM_MAP.put(ConfigGroupEnum.PLUGIN, new PluginDataRefresh(pluginDataSubscriber));
        ENUM_MAP.put(ConfigGroupEnum.SELECTOR, new SelectorDataRefresh(pluginDataSubscriber));
        ENUM_MAP.put(ConfigGroupEnum.RULE, new RuleDataRefresh(pluginDataSubscriber));
        ENUM_MAP.put(ConfigGroupEnum.APP_AUTH, new AppAuthDataRefresh(authDataSubscribers));
        ENUM_MAP.put(ConfigGroupEnum.META_DATA, new MetaDataRefresh(metaDataSubscribers));
        ENUM_MAP.put(ConfigGroupEnum.PROXY_SELECTOR, new ProxySelectorRefresh(proxySelectorDataSubscribers));
        ENUM_MAP.put(ConfigGroupEnum.DISCOVER_UPSTREAM, new DiscoveryUpstreamDataRefresh(discoveryUpstreamDataSubscribers));
    }

    public boolean executor(JsonObject data) {
        List result = ENUM_MAP.values().stream().map(dataRefresh -> dataRefresh.refresh(data)).collect(Collectors.toList());
        return result.stream().anyMatch(Boolean.TRUE::equals);
    }

    public ConfigData<?> cacheConfigData(ConfigGroupEnum group) {
        return ENUM_MAP.get(group).cacheConfigData();
    }
}

