/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.artemis;

import jakarta.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisConnectionDetails;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisConnectionFactoryConfiguration;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisEmbeddedServerConfiguration;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisMode;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisProperties;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisXAConnectionFactoryConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration(before={JmsAutoConfiguration.class}, after={JndiConnectionFactoryAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, ActiveMQConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={ArtemisProperties.class, JmsProperties.class})
@Import(value={ArtemisEmbeddedServerConfiguration.class, ArtemisXAConnectionFactoryConfiguration.class, ArtemisConnectionFactoryConfiguration.class})
public class ArtemisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ArtemisConnectionDetails.class})
    ArtemisConnectionDetails artemisConnectionDetails(ArtemisProperties properties) {
        return new PropertiesArtemisConnectionDetails(properties);
    }

    static class PropertiesArtemisConnectionDetails
    implements ArtemisConnectionDetails {
        private final ArtemisProperties properties;

        PropertiesArtemisConnectionDetails(ArtemisProperties properties) {
            this.properties = properties;
        }

        @Override
        public ArtemisMode getMode() {
            return this.properties.getMode();
        }

        @Override
        public String getBrokerUrl() {
            return this.properties.getBrokerUrl();
        }

        @Override
        public String getUser() {
            return this.properties.getUser();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }
    }
}

