/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo.proxy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ParamCheckUtils;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.apache.dubbo.cache.ApacheDubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.param.DubboParamResolveService;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ApacheDubboProxyService {
    private final DubboParamResolveService dubboParamResolveService;

    public ApacheDubboProxyService(DubboParamResolveService dubboParamResolveService) {
        this.dubboParamResolveService = dubboParamResolveService;
    }

    public Mono<Object> genericInvoker(String body, MetaData metaData, SelectorData selectorData, RuleData ruleData, ServerWebExchange exchange) throws ShenyuException {
        ReferenceConfig<GenericService> reference = this.getReferenceConfig(selectorData, ruleData, metaData, exchange);
        GenericService genericService = (GenericService)reference.get();
        Object pair = StringUtils.isBlank((CharSequence)metaData.getParameterTypes()) || ParamCheckUtils.bodyIsEmpty((String)body) ? new ImmutablePair((Object)new String[0], (Object)new Object[0]) : ("protobuf-json".equals(reference.getGeneric()) ? new ImmutablePair((Object)new String[]{metaData.getParameterTypes()}, (Object)new Object[]{JsonUtils.toJson((Object)JsonUtils.jsonToMap((String)body))}) : this.dubboParamResolveService.buildParameter(body, metaData.getParameterTypes()));
        return Mono.fromFuture((CompletableFuture)this.invokeAsync(genericService, metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight()).thenApply(ret -> {
            Object result = ret;
            if (Objects.isNull(result)) {
                result = "dubbo has not return value!";
            }
            exchange.getAttributes().put("rpc_result", result);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return result;
        })).onErrorMap(exception -> exception instanceof GenericException ? new ShenyuException(((GenericException)exception).getExceptionMessage()) : new ShenyuException(exception));
    }

    private CompletableFuture<Object> invokeAsync(GenericService genericService, String method, String[] parameterTypes, Object[] args) throws GenericException {
        genericService.$invoke(method, parameterTypes, args);
        Future resultFromFuture = RpcContext.getContext().getFuture();
        return resultFromFuture instanceof CompletableFuture ? (CompletableFuture<Object>)resultFromFuture : CompletableFuture.completedFuture(resultFromFuture);
    }

    private ReferenceConfig<GenericService> getReferenceConfig(SelectorData selectorData, RuleData ruleData, MetaData metaData, ServerWebExchange exchange) {
        List dubboUpstreams;
        String referenceKey = metaData.getPath();
        String namespace = "";
        if (CollectionUtils.isNotEmpty((Collection)exchange.getRequest().getHeaders().get((Object)"namespace"))) {
            namespace = (String)exchange.getRequest().getHeaders().get((Object)"namespace").get(0);
        }
        List list = dubboUpstreams = CollectionUtils.isEmpty((Collection)(dubboUpstreams = GsonUtils.getInstance().fromList(selectorData.getHandle(), DubboUpstream.class))) ? null : dubboUpstreams.stream().filter(u -> u.isStatus() && StringUtils.isNotBlank((CharSequence)u.getRegistry())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)dubboUpstreams)) {
            referenceKey = StringUtils.isNotBlank((CharSequence)namespace) ? namespace + ":" + referenceKey : referenceKey;
            ReferenceConfig<GenericService> reference = ApacheDubboConfigCache.getInstance().get(referenceKey);
            if (StringUtils.isEmpty((CharSequence)reference.getInterface())) {
                ApacheDubboConfigCache.getInstance().invalidate(referenceKey);
                reference = ApacheDubboConfigCache.getInstance().initRefN(metaData, namespace);
            }
            return reference;
        }
        List<Upstream> upstreams = this.convertUpstreamList(dubboUpstreams);
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        Upstream upstream = LoadBalancerFactory.selector(upstreams, (String)LoadBalanceEnum.RANDOM.getName(), (String)ip);
        DubboUpstream dubboUpstream = (DubboUpstream)dubboUpstreams.get(0);
        for (DubboUpstream upstreamItem : dubboUpstreams) {
            if (!Objects.equals(upstreamItem.getRegistry(), upstream.getUrl()) || !Objects.equals(upstreamItem.getProtocol(), upstream.getProtocol()) || !Objects.equals(upstreamItem.getVersion(), upstream.getVersion()) || !Objects.equals(upstreamItem.getGroup(), upstream.getGroup())) continue;
            dubboUpstream = upstreamItem;
            break;
        }
        referenceKey = ApacheDubboConfigCache.getInstance().generateUpstreamCacheKey(selectorData.getId(), ruleData.getId(), metaData.getId(), namespace, dubboUpstream);
        ReferenceConfig<GenericService> reference = ApacheDubboConfigCache.getInstance().get(referenceKey);
        if (StringUtils.isEmpty((CharSequence)reference.getInterface())) {
            ApacheDubboConfigCache.getInstance().invalidate(referenceKey);
            reference = ApacheDubboConfigCache.getInstance().initRefN(selectorData.getId(), ruleData, metaData, namespace, dubboUpstream);
        }
        return reference;
    }

    private List<Upstream> convertUpstreamList(List<DubboUpstream> upstreamList) {
        if (ObjectUtils.isEmpty(upstreamList)) {
            return Collections.emptyList();
        }
        return upstreamList.stream().map(u -> Upstream.builder().protocol(u.getProtocol()).url(u.getRegistry()).version(u.getVersion()).group(u.getGroup()).weight(u.getWeight()).status(u.isStatus()).timestamp(Optional.of(u.getTimestamp()).orElse(System.currentTimeMillis()).longValue()).build()).collect(Collectors.toList());
    }
}

