/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.metric.HystrixCollapserEvent;
import com.netflix.hystrix.metric.HystrixEventStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class HystrixCollapserEventStream
implements HystrixEventStream<HystrixCollapserEvent> {
    private final HystrixCollapserKey collapserKey;
    private final Subject<HystrixCollapserEvent, HystrixCollapserEvent> writeOnlyStream;
    private final Observable<HystrixCollapserEvent> readOnlyStream;
    private static final ConcurrentMap<String, HystrixCollapserEventStream> streams = new ConcurrentHashMap<String, HystrixCollapserEventStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixCollapserEventStream getInstance(HystrixCollapserKey collapserKey) {
        HystrixCollapserEventStream initialStream = (HystrixCollapserEventStream)streams.get(collapserKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<HystrixCollapserEventStream> clazz = HystrixCollapserEventStream.class;
        synchronized (HystrixCollapserEventStream.class) {
            HystrixCollapserEventStream existingStream = (HystrixCollapserEventStream)streams.get(collapserKey.name());
            if (existingStream == null) {
                HystrixCollapserEventStream newStream = new HystrixCollapserEventStream(collapserKey);
                streams.putIfAbsent(collapserKey.name(), newStream);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return existingStream;
        }
    }

    HystrixCollapserEventStream(HystrixCollapserKey collapserKey) {
        this.collapserKey = collapserKey;
        this.writeOnlyStream = new SerializedSubject((Subject)PublishSubject.create());
        this.readOnlyStream = this.writeOnlyStream.share();
    }

    public static void reset() {
        streams.clear();
    }

    public void write(HystrixCollapserEvent event) {
        this.writeOnlyStream.onNext((Object)event);
    }

    @Override
    public Observable<HystrixCollapserEvent> observe() {
        return this.readOnlyStream;
    }

    public String toString() {
        return "HystrixCollapserEventStream(" + this.collapserKey.name() + ")";
    }
}

