/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.DashboardBasedJobConfiguration;
import com.aliyun.openservices.log.common.DingTalkNotification;
import com.aliyun.openservices.log.common.EmailNotification;
import com.aliyun.openservices.log.common.Notification;
import com.aliyun.openservices.log.common.NotificationType;
import com.aliyun.openservices.log.common.TimeSpan;
import com.aliyun.openservices.log.util.JsonUtils;

public class ReportConfiguration
extends DashboardBasedJobConfiguration {
    @JSONField
    private boolean enableWatermark;
    @JSONField
    private boolean allowAnonymousAccess;
    @JSONField
    private String language;
    @JSONField
    private boolean customizePeriod;
    @JSONField
    private TimeSpan period;

    public boolean getEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public boolean getAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean getCustomizePeriod() {
        return this.customizePeriod;
    }

    public void setCustomizePeriod(boolean customizePeriod) {
        this.customizePeriod = customizePeriod;
    }

    public TimeSpan getPeriod() {
        return this.period;
    }

    public void setPeriod(TimeSpan period) {
        this.period = period;
    }

    @Override
    Notification makeQualifiedNotification(NotificationType type) {
        switch (type) {
            case DING_TALK: {
                return new DingTalkNotification();
            }
            case EMAIL: {
                return new EmailNotification();
            }
        }
        throw new IllegalArgumentException("Unimplemented report notification type: " + (Object)((Object)type));
    }

    @Override
    public void deserialize(JSONObject value) {
        super.deserialize(value);
        this.enableWatermark = JsonUtils.readBool(value, "enableWatermark", false);
        this.allowAnonymousAccess = JsonUtils.readBool(value, "allowAnonymousAccess", false);
        this.language = JsonUtils.readOptionalString(value, "language");
        this.customizePeriod = JsonUtils.readBool(value, "customizePeriod", false);
        if (this.customizePeriod) {
            this.period = new TimeSpan();
            this.period.deserialize(value.getJSONObject("period"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportConfiguration that = (ReportConfiguration)o;
        if (this.getEnableWatermark() != that.getEnableWatermark()) {
            return false;
        }
        if (this.getAllowAnonymousAccess() != that.getAllowAnonymousAccess()) {
            return false;
        }
        if (this.getCustomizePeriod() != that.getCustomizePeriod()) {
            return false;
        }
        if (this.getLanguage() != null ? !this.getLanguage().equals(that.getLanguage()) : that.getLanguage() != null) {
            return false;
        }
        return this.getPeriod() != null ? this.getPeriod().equals(that.getPeriod()) : that.getPeriod() == null;
    }

    public int hashCode() {
        int result = this.getEnableWatermark() ? 1 : 0;
        result = 31 * result + (this.getAllowAnonymousAccess() ? 1 : 0);
        result = 31 * result + (this.getLanguage() != null ? this.getLanguage().hashCode() : 0);
        result = 31 * result + (this.getCustomizePeriod() ? 1 : 0);
        result = 31 * result + (this.getPeriod() != null ? this.getPeriod().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ReportConfiguration{enableWatermark=" + this.enableWatermark + ", allowAnonymousAccess=" + this.allowAnonymousAccess + ", language='" + this.language + '\'' + ", customizePeriod=" + this.customizePeriod + ", period=" + this.period + '}';
    }
}

