/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.log.common.IndexKeys;
import com.aliyun.openservices.log.common.IndexLine;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.List;

public class Index {
    private int ttl = -1;
    private IndexKeys keys = new IndexKeys();
    private IndexLine line = new IndexLine();
    private boolean keysSet = false;
    private boolean lineSet = false;
    private boolean logReduceEnable = false;
    private int maxTextLen = 0;
    private List<String> logReduceWhiteList = new ArrayList<String>();
    private List<String> logReduceBlackList = new ArrayList<String>();

    public Index() {
    }

    public Index(int ttl, IndexKeys keys, IndexLine line) {
        this.ttl = ttl;
        this.SetKeys(keys);
        this.SetLine(line);
    }

    public Index(Index other) {
        this.ttl = other.GetTtl();
        this.logReduceEnable = other.isLogReduceEnable();
        if (other.isKeysSet()) {
            this.SetKeys(other.GetKeys());
        }
        if (other.isLineSet()) {
            this.SetLine(other.GetLine());
        }
        this.maxTextLen = other.getMaxTextLen();
        this.setLogReduceWhiteList(other.getLogReduceWhiteList());
        this.setLogReduceBlackList(other.getLogReduceBlackList());
    }

    public boolean isLogReduceEnable() {
        return this.logReduceEnable;
    }

    public void setLogReduceEnable(boolean logReduce) {
        this.logReduceEnable = logReduce;
    }

    public boolean isKeysSet() {
        return this.keysSet;
    }

    public boolean isLineSet() {
        return this.lineSet;
    }

    public int GetTtl() {
        return this.ttl;
    }

    public void SetTtl(int ttl) {
        this.ttl = ttl;
    }

    public IndexKeys GetKeys() {
        return this.keys;
    }

    public IndexLine GetLine() {
        return this.line;
    }

    public void SetKeys(IndexKeys keys) {
        this.keysSet = true;
        this.keys = new IndexKeys(keys);
    }

    public void SetLine(IndexLine line) {
        this.lineSet = true;
        this.line = new IndexLine(line);
    }

    public int getMaxTextLen() {
        return this.maxTextLen;
    }

    public void setMaxTextLen(int maxTextLen) {
        this.maxTextLen = maxTextLen;
    }

    public List<String> getLogReduceWhiteList() {
        return this.logReduceWhiteList;
    }

    public void setLogReduceWhiteList(List<String> logReduceWhiteList) {
        this.logReduceWhiteList = logReduceWhiteList;
    }

    public List<String> getLogReduceBlackList() {
        return this.logReduceBlackList;
    }

    public void setLogReduceBlackList(List<String> logReduceBlackList) {
        this.logReduceBlackList = logReduceBlackList;
    }

    public JSONObject ToRequestJson() throws LogException {
        JSONObject index = new JSONObject();
        index.put("ttl", (Object)this.ttl);
        index.put("log_reduce", (Object)this.logReduceEnable);
        if (this.lineSet) {
            JSONObject lineDict = this.line.ToJsonObject();
            index.put("line", (Object)lineDict);
        }
        if (this.keysSet) {
            JSONObject keysDict = this.keys.ToJsonObject();
            index.put("keys", (Object)keysDict);
        }
        if (this.maxTextLen > 0) {
            index.put("max_text_len", (Object)this.maxTextLen);
        }
        if (this.logReduceWhiteList.size() > 0) {
            JSONArray logReduceWhiteListDict = new JSONArray();
            logReduceWhiteListDict.addAll(this.logReduceWhiteList);
            index.put("log_reduce_white_list", (Object)logReduceWhiteListDict);
        }
        if (this.logReduceBlackList.size() > 0) {
            JSONArray logReduceBlackListDict = new JSONArray();
            logReduceBlackListDict.addAll(this.logReduceBlackList);
            index.put("log_reduce_black_list", (Object)logReduceBlackListDict);
        }
        return index;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject index = this.ToRequestJson();
        return index;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            int i;
            this.ttl = dict.getIntValue("ttl");
            if (dict.containsKey((Object)"line")) {
                JSONObject lineDict = dict.getJSONObject("line");
                this.line.FromJsonObject(lineDict);
                this.lineSet = true;
            }
            if (dict.containsKey((Object)"keys")) {
                JSONObject keysDict = dict.getJSONObject("keys");
                this.keys.FromJsonObject(keysDict);
                this.keysSet = true;
            }
            if (dict.containsKey((Object)"log_reduce")) {
                this.logReduceEnable = dict.getBooleanValue("log_reduce");
            }
            if (dict.containsKey((Object)"max_text_len")) {
                this.maxTextLen = dict.getIntValue("max_text_len");
            }
            if (dict.containsKey((Object)"log_reduce_white_list")) {
                JSONArray logReduceWhiteListDict = dict.getJSONArray("log_reduce_white_list");
                this.logReduceWhiteList = new ArrayList<String>();
                for (i = 0; i < logReduceWhiteListDict.size(); ++i) {
                    this.logReduceWhiteList.add(logReduceWhiteListDict.getString(i));
                }
            }
            if (dict.containsKey((Object)"log_reduce_black_list")) {
                JSONArray logReduceBlackListDict = dict.getJSONArray("log_reduce_black_list");
                this.logReduceBlackList = new ArrayList<String>();
                for (i = 0; i < logReduceBlackListDict.size(); ++i) {
                    this.logReduceBlackList.add(logReduceBlackListDict.getString(i));
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndex", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject((String)indexString, (Feature[])new Feature[]{Feature.DisableSpecialKeyDetect});
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndex", e.getMessage(), e, "");
        }
    }
}

