/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.api;

import io.etcd.jetcd.api.WatchGrpc;
import io.etcd.jetcd.api.WatchProgressRequest;
import io.etcd.jetcd.api.WatchRequest;
import io.etcd.jetcd.api.WatchResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.stub.ClientCalls;

public final class VertxWatchGrpc {
    private static final int METHODID_PROGRESS = 0;
    private static final int METHODID_WATCH = 1;

    private VertxWatchGrpc() {
    }

    public static WatchVertxStub newVertxStub(Channel channel) {
        return new WatchVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WatchVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(WatchVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((WatchProgressRequest)request), responseObserver, (String)this.compression, this.serviceImpl::progress);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return io.vertx.grpc.stub.ServerCalls.manyToMany(responseObserver, (String)this.compression, this.serviceImpl::watch);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class WatchVertxImplBase
    implements BindableService {
        private String compression;

        public WatchVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<WatchResponse> progress(WatchProgressRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public void watch(ReadStream<WatchRequest> request, WriteStream<WatchResponse> response) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)WatchGrpc.getServiceDescriptor()).addMethod(WatchGrpc.getProgressMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(WatchGrpc.getWatchMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1, this.compression))).build();
        }
    }

    public static final class WatchVertxStub
    extends AbstractStub<WatchVertxStub> {
        private final ContextInternal ctx;
        private WatchGrpc.WatchStub delegateStub;

        private WatchVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = WatchGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private WatchVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = WatchGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected WatchVertxStub build(Channel channel, CallOptions callOptions) {
            return new WatchVertxStub(channel, callOptions);
        }

        public Future<WatchResponse> progress(WatchProgressRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::progress);
        }

        public ReadStream<WatchResponse> watch(Handler<WriteStream<WatchRequest>> hdlr) {
            return ClientCalls.manyToMany((ContextInternal)this.ctx, hdlr, this.delegateStub::watch);
        }
    }
}

