/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.common.spring.ai.factory;

import java.util.Optional;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.ai.common.spring.ai.AiModelFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.api.OpenAiApi;

public class OpenAiModelFactory
implements AiModelFactory {
    private static final AiModelProviderEnum MODEL_PROVIDER_ENUM = AiModelProviderEnum.OPEN_AI;

    @Override
    public ChatModel createAiModel(AiCommonConfig config) {
        OpenAiApi openAiApi = OpenAiApi.builder().baseUrl(config.getBaseUrl()).apiKey(config.getApiKey()).build();
        OpenAiChatOptions.Builder model = OpenAiChatOptions.builder().model(config.getModel());
        Optional.ofNullable(config.getTemperature()).ifPresent(arg_0 -> ((OpenAiChatOptions.Builder)model).temperature(arg_0));
        Optional.ofNullable(config.getMaxTokens()).ifPresent(arg_0 -> ((OpenAiChatOptions.Builder)model).maxTokens(arg_0));
        return OpenAiChatModel.builder().openAiApi(openAiApi).defaultOptions(model.build()).build();
    }

    @Override
    public boolean supports(AiModelProviderEnum modelType) {
        return MODEL_PROVIDER_ENUM.equals((Object)modelType);
    }
}

